package com.smart.panorama.util;

import android.text.TextUtils;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * okhttp重定向拦截器
 * @Author CharlesLui
 */
public class RedirectInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);

        Response clone = response.newBuilder().build();


        if (clone.isRedirect()) {

            String redirectUrl = clone.header("Location");

            if (!TextUtils.isEmpty(redirectUrl)) {
                response.close();
                Request newRequest = request.newBuilder().url(redirectUrl).build();
                return chain.proceed(newRequest);
            }
        }

        return response;
    }
}
