package com.smart.panorama.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * JSON方式保存配置
 */
public class ObjectSharedPreference {
    private static final String DEFAULT_SHARE_NAME = "default_share_object";
    private static final String DEFAULT_SHARE_NAME_LIST_APPEND = "_list";
    SharedPreferences mPreferences;

    public ObjectSharedPreference(Context context) {
        mPreferences = context.getSharedPreferences(DEFAULT_SHARE_NAME, Context.MODE_PRIVATE);
    }

    public ObjectSharedPreference(Context context, String sharedpreferencesName) {
        mPreferences = context.getSharedPreferences(sharedpreferencesName, Context.MODE_PRIVATE);
    }

    public void save(Object object) {
        save(object.getClass().getName(), object);
    }

    public void save(String key, Object object) {
        Gson gson = new Gson();
        SharedPreferences.Editor editor = mPreferences.edit();
        editor.putString(key, gson.toJson(object));
        editor.apply();
    }

    public <T> T get(Class<T> tClass) {
        return get(tClass.getName(), tClass);
    }

    public <T> T get(String key, Class<T> tClass) {
        try {
            String value = mPreferences.getString(key, "");
            if (TextUtils.isEmpty(value)) {
                return null;
            }
            Gson gson = new Gson();
            T t = gson.fromJson(value, tClass);
            return t;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> void saveList(List<T> list) {
        if (list == null || list.size() == 0)
            return;

        saveList(list.get(0).getClass().getName() + DEFAULT_SHARE_NAME_LIST_APPEND, list);
    }

    public <T> void saveList(String key, List<T> list) {
        if (list == null || list.size() == 0)
            return;

        Gson gson = new Gson();

        List<String> strlist = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            strlist.add(gson.toJson(list.get(i)));
        }

        SharedPreferences.Editor editor = mPreferences.edit();
        editor.putString(key, gson.toJson(strlist));
        editor.commit();
    }

    public <T> List<T> getList(Class<T> tClass) {
        return getList(tClass.getName() + DEFAULT_SHARE_NAME_LIST_APPEND, tClass);
    }

    public <T> List<T> getList(String key, Class<T> T) {
        try {
            String value = mPreferences.getString(key, "");
            if (TextUtils.isEmpty(value)) {
                return null;
            }
            Gson gson = new Gson();

            Type type = new TypeToken<ArrayList<String>>() {
            }.getType();
            List<String> strList = gson.fromJson(value, type);
            if (strList == null)
                return null;

            List<T> list = new ArrayList<T>();
            for (int i = 0; i < strList.size(); i++) {
                list.add(gson.fromJson(strList.get(i), T));
            }
            return list;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
