package com.smart.panorama.oss;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.OSS;
import com.alibaba.sdk.android.oss.OSSClient;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.common.OSSConstants;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSCustomSignerCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.IOUtils;
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.google.gson.reflect.TypeToken;
import com.smart.panorama.PanoPublishUtils;
import com.smart.panorama.callback.OSSCallback;
import com.smart.panorama.model.BaseResult;
import com.smart.panorama.model.LoginInfo;
import com.smart.panorama.util.JsonUtils;

import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class OSSUploadUtils {
    private final static String[] chars = new String[]{"a", "b", "c", "d", "e", "f",
            "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s",
            "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5",
            "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I",
            "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V",
            "W", "X", "Y", "Z"};
    private static OSS oss;
    private static final String bucketName = "wl-panorama";
    private static OSSUploadUtils instance;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    private OSSCallback OSSCallback;
    private List<UploadFile> completes = new ArrayList<>();
    private boolean isUploading;

    public static OSSUploadUtils getInstance(Context context) {

        if (instance == null) {
            instance = new OSSUploadUtils(context);
        }

        return instance;

    }

    private OSSUploadUtils(Context context) {
        if (oss == null) {
            String endpoint = "http://oss.m2m88.com/";
            OSSCredentialProvider provider = new OSSCustomSignerCredentialProvider() {
                @Override
                public String signContent(String content) {

                    String signature = "";

                    LoginInfo loginInfo = PanoPublishUtils.getLoginInfo();

                    if (loginInfo == null) {

                        PanoPublishUtils.handler.post(new Runnable() {
                            @Override
                            public void run() {
                                if (OSSCallback != null) {
                                    OSSCallback.onFailed("请先登录");
                                }
                            }
                        });

                    } else {
                        try {
                            URL stsUrl = new URL("http://39.98.58.224:8080/panorama/api/v1/user/getPolicy?uid=" + loginInfo.getId() + "&content="
                                    + URLEncoder.encode(content, "UTF-8"));
                            HttpURLConnection conn = (HttpURLConnection) stsUrl.openConnection();
                            InputStream input = conn.getInputStream();
                            String jsonText = IOUtils.readStreamAsString(input, OSSConstants.DEFAULT_CHARSET_NAME);

                            BaseResult<String> baseResult = JsonUtils.fromJson(jsonText, new TypeToken<BaseResult<String>>() {
                            }.getType());

                            if (baseResult == null) {
                                PanoPublishUtils.handler.post(new Runnable() {
                                    @Override
                                    public void run() {
                                        if (OSSCallback != null) {
                                            OSSCallback.onFailed("系统错误");
                                        }
                                    }
                                });
                            } else {

                                if (baseResult.isSuccess()) {
                                    signature = baseResult.getData();
                                } else {
                                    PanoPublishUtils.handler.post(new Runnable() {
                                        @Override
                                        public void run() {
                                            if (OSSCallback != null) {
                                                OSSCallback.onFailed(baseResult.getMessage());
                                            }
                                        }
                                    });
                                }
                            }

                        } catch (Exception e) {
                            PanoPublishUtils.handler.post(new Runnable() {
                                @Override
                                public void run() {
                                    if (OSSCallback != null) {
                                        OSSCallback.onFailed(e.getMessage());
                                    }
                                }
                            });
                        }
                    }

                    return signature;
                }
            };

            oss = new OSSClient(context, endpoint, provider);
        }
    }

    /**
     * 上传多文件
     *
     * @param paths
     */
    public void uploadFiles(List<UploadFile> paths) {
        if (null == paths || paths.size() == 0) {
            if (OSSCallback != null) {
                OSSCallback.onFailed("上传文件不能为空");
            }
            return;
        } // 上传文件

        if (isUploading) {
            return;
        }
        isUploading = true;
        completes.clear();
        ossUpload(new ArrayList<>(paths));
    }

    /**
     * 阿里云OSS上传（默认是异步多文件上传）
     *
     * @param paths
     */
    private void ossUpload(final List<UploadFile> paths) {
        if (paths.size() <= 0) {
            isUploading = false;
            PanoPublishUtils.handler.post(new Runnable() {
                @Override
                public void run() {
                    // 文件全部上传完毕，这里编写上传结束的逻辑，如果要在主线程操作，最好用Handler或runOnUiThread做对应逻辑
                    if (OSSCallback != null) {
                        OSSCallback.onComplete(completes);
                    }
                }
            });
            return;// 这个return必须有，否则下面报越界异常，原因自己思考下哈
        }
        final UploadFile path = paths.get(0);
        if (path == null) {
            paths.remove(0);
            // url为空就没必要上传了，这里做的是跳过它继续上传的逻辑。
            ossUpload(paths);
            return;
        }
        File file = new File(path.getLocalPath());
        if (!file.exists()) {
            paths.remove(0);
            // 文件为空或不存在就没必要上传了，这里做的是跳过它继续上传的逻辑。
            ossUpload(paths);
            return;
        }

        if (TextUtils.isEmpty(path.getObjectKey())) {
            path.setObjectKey(genObjectKey("", file));
        }

        // 下面3个参数依次为bucket名，ObjectKey名，上传文件路径
        PutObjectRequest put = new PutObjectRequest(bucketName, path.getObjectKey(), path.getLocalPath());
        // 设置进度回调
        put.setProgressCallback(new OSSProgressCallback<PutObjectRequest>() {
            @Override
            public void onProgress(PutObjectRequest request, long currentSize, long totalSize) {
                // 进度逻辑
                int progress = (int) (currentSize * 100 / totalSize);
            }
        });
        // 异步上传
        OSSAsyncTask task = oss.asyncPutObject(put,
                new OSSCompletedCallback<PutObjectRequest, PutObjectResult>() {
                    @Override
                    public void onSuccess(PutObjectRequest request, PutObjectResult result) { // 上传成功

                        PanoPublishUtils.handler.post(new Runnable() {
                            @Override
                            public void run() {
                                // 文件全部上传完毕，这里编写上传结束的逻辑，如果要在主线程操作，最好用Handler或runOnUiThread做对应逻辑
                                if (OSSCallback != null) {
                                    OSSCallback.onProgress(path.getFileName());
                                }
                            }
                        });

                        completes.add(path);
                        paths.remove(0);
                        ossUpload(paths);// 递归同步效果
                    }

                    @Override
                    public void onFailure(PutObjectRequest request, ClientException clientExcepion,
                                          ServiceException serviceException) { // 上传失败
//
//                        PanoPublishUtils.handler.post(new Runnable() {
//                            @Override
//                            public void run() {
//                                // 文件全部上传完毕，这里编写上传结束的逻辑，如果要在主线程操作，最好用Handler或runOnUiThread做对应逻辑
//                                if (OSSCallback != null) {
//                                    OSSCallback.onProgress(request.getUploadFilePath() + " --> 上传失败");
//                                }
//                            }
//                        });
                        // 请求异常
                        if (clientExcepion != null) {
                            // 本地异常如网络异常等
                            clientExcepion.printStackTrace();
                        }
                        if (serviceException != null) {
                            // 服务异常
                            Log.e("ErrorCode", serviceException.getErrorCode());
                            Log.e("RequestId", serviceException.getRequestId());
                            Log.e("HostId", serviceException.getHostId());
                            Log.e("RawMessage", serviceException.getRawMessage());
                        }
                        paths.remove(0);
                        ossUpload(paths);// 递归同步效果
                    }
                });
        // task.cancel(); // 可以取消任务
        // task.waitUntilFinished(); // 可以等待直到任务完成
    }

    /**
     * @Description: <p>
     * 短8位UUID思想其实借鉴微博短域名的生成方式，但是其重复概率过高，而且每次生成4个，需要随即选取一个。
     * 本算法利用62个可打印字符，通过随机生成32位UUID，由于UUID都为十六进制，所以将UUID分成8组，每4个为一组，然后通过模62操作，结果作为索引取出字符，
     * 这样重复率大大降低。
     * 经测试，在生成一千万个数据也没有出现重复，完全满足大部分需求。
     * </p>
     */
    private static String getAppId() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; i++) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 0x3E]);
        }
        return shortBuffer.toString();

    }

    public static String genObjectKey(String userId, File file) {

        // 文件后缀
        String fileSuffix = "";
        if (file.isFile()) {
            // 获取文件后缀名
            fileSuffix = file.getName().substring(file.getName().lastIndexOf("."));
        }
        // 文件标识符objectKey
        String objectKey;
        if (TextUtils.isEmpty(userId)) {
            objectKey = "sourceimg/android_" + sdf.format(new Date()) + "_" + getAppId() + fileSuffix;
        } else {
            objectKey = userId + "/sourceimg/android_" + sdf.format(new Date()) + "_" + getAppId() + fileSuffix;
        }

        return objectKey;
    }

    public static String genObjectKey(String userId, String filePath) {

        return genObjectKey(userId, new File(filePath));
    }

    public OSSUploadUtils setListener(OSSCallback OSSCallback) {
        this.OSSCallback = OSSCallback;
        return this;
    }


}
