/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.util;

import com.google.gson.Gson;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.salt.function.flow.Info;
import org.salt.function.flow.context.ContextBus;
import org.salt.function.flow.context.IContextBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public class FlowUtil {
    private static final Logger log = LoggerFactory.getLogger(FlowUtil.class);
    static ExpressRunner runner = new ExpressRunner();
    private static final Gson gson = new Gson();

    public static boolean el(String condition, Map<String, Object> conditionMap) {
        DefaultContext defaultContext = new DefaultContext();
        defaultContext.putAll(conditionMap);
        try {
            return (Boolean)runner.execute(condition, (IExpressContext)defaultContext, null, true, false);
        }
        catch (Exception e) {
            log.warn("el exception. include:{}, conditionMap:{}, exception:", new Object[]{condition, FlowUtil.toJson(conditionMap), e});
            return false;
        }
    }

    public static String getNodeInfoKey(String nodeId) {
        return String.format("node_info_%s", nodeId);
    }

    public static <P> boolean isExe(IContextBus iContextBus, Info<P, ?> info) {
        ContextBus contextBus = (ContextBus)iContextBus;
        return StringUtils.isEmpty((String)info.include) && info.match == null || StringUtils.isNotEmpty((String)info.include) && FlowUtil.el(info.include, contextBus.getConditionMap()) || info.match != null && info.match.apply(contextBus) != false;
    }

    public static Object getTarget(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return FlowUtil.getJdkDynamicProxyTargetObject(proxy);
        }
        return FlowUtil.getCglibProxyTargetObject(proxy);
    }

    public static Object getCglibProxyTargetObject(Object proxy) {
        try {
            Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
            h.setAccessible(true);
            Object dynamicAdvisedInterceptor = h.get(proxy);
            Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
            advised.setAccessible(true);
            return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
    }

    public static String toJson(Object o) {
        return gson.toJson(o);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)gson.fromJson(json, classOfT);
    }
}

