/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.salt.function.flow.Info;
import org.salt.function.flow.thread.IThreadContent;
import org.salt.function.flow.util.FlowUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheadHelper {
    private static final Logger log = LoggerFactory.getLogger(TheadHelper.class);
    private IThreadContent threadContent;
    private ExecutorService executor;
    private long timeout;
    private static ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocal();

    public static <P> void putThreadLocal(String key, P value) {
        if (threadLocal.get() == null) {
            threadLocal.set(new HashMap());
        }
        threadLocal.get().put(key, value);
    }

    public static <P> P getThreadLocal(String key) {
        if (threadLocal.get() == null) {
            threadLocal.set(new HashMap());
        }
        return (P)threadLocal.get().get(key);
    }

    public static void clean() {
        threadLocal.set(null);
    }

    public Runnable getDecoratorSync(Runnable runnable, Info info) {
        return () -> {
            TheadHelper.putThreadLocal(FlowUtil.getNodeInfoKey(info.id), info);
            try {
                runnable.run();
            }
            finally {
                TheadHelper.putThreadLocal(FlowUtil.getNodeInfoKey(info.id), null);
            }
        };
    }

    public Runnable getDecoratorAsync(Runnable runnable, Info info) {
        HashMap<String, Object> map = new HashMap<String, Object>(threadLocal.get());
        Object content = this.getThreadContent();
        return () -> {
            threadLocal.set(map);
            this.setThreadContent(content);
            TheadHelper.putThreadLocal(FlowUtil.getNodeInfoKey(info.id), info);
            try {
                runnable.run();
            }
            finally {
                TheadHelper.putThreadLocal(FlowUtil.getNodeInfoKey(info.id), null);
                this.cleanThreadContent();
                threadLocal.set(null);
            }
        };
    }

    public Callable getDecoratorAsync(Callable callable, Info info) {
        HashMap<String, Object> map = new HashMap<String, Object>(threadLocal.get());
        Object content = this.getThreadContent();
        return () -> {
            threadLocal.set(map);
            this.setThreadContent(content);
            TheadHelper.putThreadLocal(FlowUtil.getNodeInfoKey(info.id), info);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                TheadHelper.putThreadLocal(FlowUtil.getNodeInfoKey(info.id), null);
                this.cleanThreadContent();
                threadLocal.set(null);
            }
        };
    }

    private Object getThreadContent() {
        if (this.threadContent != null) {
            return this.threadContent.getThreadContent();
        }
        return null;
    }

    private void setThreadContent(Object content) {
        if (this.threadContent != null) {
            this.threadContent.setThreadContent(content);
        }
    }

    private void cleanThreadContent() {
        if (this.threadContent != null) {
            this.threadContent.cleanThreadContent();
        }
    }

    TheadHelper(IThreadContent threadContent, ExecutorService executor, long timeout) {
        this.threadContent = threadContent;
        this.executor = executor;
        this.timeout = timeout;
    }

    public static TheadHelperBuilder builder() {
        return new TheadHelperBuilder();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TheadHelper)) {
            return false;
        }
        TheadHelper other = (TheadHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        Object this$threadContent = this.getThreadContent();
        Object other$threadContent = other.getThreadContent();
        if (this$threadContent == null ? other$threadContent != null : !this$threadContent.equals(other$threadContent)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TheadHelper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        Object $threadContent = this.getThreadContent();
        result = result * 59 + ($threadContent == null ? 43 : $threadContent.hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    public String toString() {
        return "TheadHelper(threadContent=" + this.getThreadContent() + ", executor=" + this.getExecutor() + ", timeout=" + this.getTimeout() + ")";
    }

    public static class TheadHelperBuilder {
        private IThreadContent threadContent;
        private ExecutorService executor;
        private long timeout;

        TheadHelperBuilder() {
        }

        public TheadHelperBuilder threadContent(IThreadContent threadContent) {
            this.threadContent = threadContent;
            return this;
        }

        public TheadHelperBuilder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public TheadHelperBuilder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public TheadHelper build() {
            return new TheadHelper(this.threadContent, this.executor, this.timeout);
        }

        public String toString() {
            return "TheadHelper.TheadHelperBuilder(threadContent=" + this.threadContent + ", executor=" + this.executor + ", timeout=" + this.timeout + ")";
        }
    }
}

