/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.node.structure.internal;

import java.util.List;
import org.salt.function.flow.Info;
import org.salt.function.flow.context.ContextBus;
import org.salt.function.flow.context.IContextBus;
import org.salt.function.flow.node.structure.FlowNodeStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowNodeWait<P>
extends FlowNodeStructure<P> {
    private static final Logger log = LoggerFactory.getLogger(FlowNodeWait.class);

    @Override
    public P doProcessGateway(IContextBus iContextBus, List<Info> infoList) {
        long lastTimeout = this.theadHelper.getTimeout();
        for (Info info : infoList) {
            if (lastTimeout <= 0L) {
                ((ContextBus)iContextBus).putPassException(info.id, new RuntimeException("beyond maxTimeout"));
                return this.result(iContextBus, true);
            }
            long start = System.currentTimeMillis();
            try {
                Object result = ((ContextBus)iContextBus).getPassResult(info.id, lastTimeout);
                if (result != null) {
                    ((ContextBus)iContextBus).putPassResult(info.id, result);
                } else {
                    ((ContextBus)iContextBus).removePassResult(info.id);
                }
            }
            catch (Exception e) {
                ((ContextBus)iContextBus).putPassException(info.id, e);
            }
            lastTimeout -= System.currentTimeMillis() - start;
        }
        if (this.isSuspend(iContextBus)) {
            return null;
        }
        return this.result(iContextBus, lastTimeout <= 0L);
    }

    public P result(IContextBus iContextBus, boolean isTimeout) {
        if (this.result != null) {
            return this.result.handle(iContextBus, isTimeout);
        }
        return null;
    }
}

