/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.node.structure.internal;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.salt.function.flow.Info;
import org.salt.function.flow.context.ContextBus;
import org.salt.function.flow.context.IContextBus;
import org.salt.function.flow.node.structure.FlowNodeStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowNodeConcurrent<P>
extends FlowNodeStructure<P> {
    private static final Logger log = LoggerFactory.getLogger(FlowNodeConcurrent.class);

    @Override
    public P doProcessGateway(IContextBus iContextBus, List<Info> infoList) {
        CountDownLatch finalCountDownLatch = new CountDownLatch(infoList.size());
        for (Info info : infoList) {
            this.theadHelper.getExecutor().submit(this.theadHelper.getDecoratorAsync(() -> {
                try {
                    this.executeVoid(iContextBus, info.id);
                }
                catch (Exception e) {
                    ((ContextBus)iContextBus).putPassException(info.id, e);
                }
                finally {
                    finalCountDownLatch.countDown();
                }
            }, info));
        }
        if (this.isSuspend(iContextBus)) {
            return null;
        }
        try {
            boolean isTimeout = finalCountDownLatch.await(this.theadHelper.getTimeout(), TimeUnit.MILLISECONDS);
            if (this.result != null) {
                return this.result.handle(iContextBus, !isTimeout);
            }
        }
        catch (InterruptedException e) {
            ((ContextBus)iContextBus).putPassException(this.nodeId, e);
        }
        return null;
    }
}

