/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.node.structure;

import java.util.List;
import java.util.stream.Collectors;
import org.salt.function.flow.FlowEngine;
import org.salt.function.flow.Info;
import org.salt.function.flow.context.ContextBus;
import org.salt.function.flow.context.IContextBus;
import org.salt.function.flow.node.FlowNodeWithReturn;
import org.salt.function.flow.node.IResult;
import org.salt.function.flow.node.register.FlowNodeManager;
import org.salt.function.flow.thread.TheadHelper;
import org.salt.function.flow.util.FlowUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class FlowNodeStructure<P>
extends FlowNodeWithReturn<P> {
    private static final Logger log = LoggerFactory.getLogger(FlowNodeStructure.class);
    protected FlowEngine flowEngine;
    protected FlowNodeManager flowNodeManager;
    protected IResult<P> result;
    protected List<Info<P, ?>> infoList;
    protected TheadHelper theadHelper;

    public void setFlowEngine(FlowEngine flowEngine) {
        this.flowEngine = flowEngine;
    }

    public void setFlowNodeManager(FlowNodeManager flowNodeManager) {
        this.flowNodeManager = flowNodeManager;
    }

    public void setResult(IResult<P> result) {
        this.result = result;
    }

    public void setNodeInfoList(List<Info<P, ?>> infoList) {
        this.infoList = infoList;
    }

    public void setTheadHelper(TheadHelper theadHelper) {
        this.theadHelper = theadHelper;
    }

    protected boolean isFlowNode(String nodeId) {
        return this.flowNodeManager.getIFlowNode(nodeId) != null;
    }

    @Override
    public P doProcess(IContextBus iContextBus) {
        if (CollectionUtils.isEmpty(this.infoList)) {
            return null;
        }
        List<Info> infoListExe = this.infoList.stream().filter(info -> FlowUtil.isExe(iContextBus, info)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(infoListExe)) {
            return null;
        }
        return this.doProcessGateway(iContextBus, infoListExe);
    }

    protected P doProcessGateway(IContextBus iContextBus, List<Info> infoList) {
        return null;
    }

    protected P execute(IContextBus iContextBus, String id) {
        if (this.isFlowNode(id)) {
            return (P)this.flowNodeManager.execute(iContextBus, id);
        }
        return (P)this.flowEngine.executeBranch(iContextBus, id);
    }

    protected void executeVoid(IContextBus iContextBus, String id) {
        if (this.isFlowNode(id)) {
            this.flowNodeManager.executeVoid(iContextBus, id);
        } else {
            this.flowEngine.executeBranchVoid(iContextBus, id);
        }
    }

    protected boolean isSuspend(IContextBus iContextBus) {
        return ((ContextBus)iContextBus).isRollbackProcess() || ((ContextBus)iContextBus).isStopProcess();
    }
}

