/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.node.register;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.salt.function.flow.context.ContextBus;
import org.salt.function.flow.context.IContextBus;
import org.salt.function.flow.node.FlowNodeWithReturn;
import org.salt.function.flow.node.IFlowNode;
import org.salt.function.flow.node.register.NodeIdentity;
import org.salt.function.flow.util.FlowUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowNodeManager {
    private static final Logger log = LoggerFactory.getLogger(FlowNodeManager.class);
    private Map<String, IFlowNode> flowNodeMap = new HashMap<String, IFlowNode>();

    public void doRegistration(IFlowNode iFlowNode) {
        Class<?> nodeClazz = this.getNodeClazz(iFlowNode);
        NodeIdentity nodeIdentity = nodeClazz.getDeclaredAnnotation(NodeIdentity.class);
        String nodeId = nodeIdentity != null ? nodeIdentity.nodeId() : iFlowNode.nodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            throw new RuntimeException("nodeId or extConfig must not be all null ");
        }
        if (this.flowNodeMap.containsKey(nodeId)) {
            throw new RuntimeException("repeat node " + iFlowNode.nodeId());
        }
        this.flowNodeMap.put(nodeId, iFlowNode);
    }

    public IFlowNode getIFlowNode(String nodeId) {
        return this.flowNodeMap.get(nodeId);
    }

    private Class<?> getNodeClazz(IFlowNode iFlowNode) {
        Object target = null;
        try {
            target = FlowUtil.getTarget(iFlowNode);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
        if (target == null) {
            throw new RuntimeException("get aop target failed with error :" + iFlowNode.getClass());
        }
        return target.getClass();
    }

    public <R> R execute(IContextBus iContextBus, String nodeId) {
        IFlowNode iFlowNode = this.flowNodeMap.get(nodeId);
        if (iFlowNode != null && iFlowNode instanceof FlowNodeWithReturn) {
            Object result = ((FlowNodeWithReturn)iFlowNode).doProcess(iContextBus);
            ((ContextBus)iContextBus).roolbackExec(iFlowNode);
            return (R)result;
        }
        return null;
    }

    public void executeVoid(IContextBus iContextBus, String nodeId) {
        IFlowNode iFlowNode = this.flowNodeMap.get(nodeId);
        if (iFlowNode != null) {
            iFlowNode.process(iContextBus);
            ((ContextBus)iContextBus).roolbackExec(iFlowNode);
        }
    }

    public void executeVoidSingle(IContextBus iContextBus, String nodeId) {
        IFlowNode iFlowNode = this.flowNodeMap.get(nodeId);
        if (iFlowNode != null) {
            iFlowNode.process(iContextBus);
        }
    }

    public <R> R execute(String nodeId, Function<IFlowNode, R> exeFunction) {
        IFlowNode iFlowNode = this.flowNodeMap.get(nodeId);
        if (iFlowNode != null) {
            return exeFunction.apply(iFlowNode);
        }
        return null;
    }

    public void executeVoid(String nodeId, Consumer<IFlowNode> exeFunction) {
        IFlowNode IFlowNode2 = this.flowNodeMap.get(nodeId);
        if (IFlowNode2 != null) {
            exeFunction.accept(IFlowNode2);
        }
    }

    public Map<String, IFlowNode> getFlowNodeMap() {
        return this.flowNodeMap;
    }

    public void setFlowNodeMap(Map<String, IFlowNode> flowNodeMap) {
        this.flowNodeMap = flowNodeMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowNodeManager)) {
            return false;
        }
        FlowNodeManager other = (FlowNodeManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, IFlowNode> this$flowNodeMap = this.getFlowNodeMap();
        Map<String, IFlowNode> other$flowNodeMap = other.getFlowNodeMap();
        return !(this$flowNodeMap == null ? other$flowNodeMap != null : !((Object)this$flowNodeMap).equals(other$flowNodeMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowNodeManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, IFlowNode> $flowNodeMap = this.getFlowNodeMap();
        result = result * 59 + ($flowNodeMap == null ? 43 : ((Object)$flowNodeMap).hashCode());
        return result;
    }

    public String toString() {
        return "FlowNodeManager(flowNodeMap=" + this.getFlowNodeMap() + ")";
    }
}

