/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.node;

import org.apache.commons.lang3.StringUtils;
import org.salt.function.flow.Info;
import org.salt.function.flow.context.ContextBus;
import org.salt.function.flow.context.IContextBus;
import org.salt.function.flow.node.FlowNode;
import org.salt.function.flow.util.FlowUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowNodeWithReturn<P>
extends FlowNode {
    private static final Logger log = LoggerFactory.getLogger(FlowNodeWithReturn.class);

    @Override
    public void process(IContextBus iContextBus) {
        ContextBus contextBus = (ContextBus)iContextBus;
        P result = this.doProcess(iContextBus);
        if (result != null) {
            String idTmp = this.nodeId;
            Object adapterResult = null;
            Info info = ContextBus.getNodeInfo(FlowUtil.getNodeInfoKey(this.nodeId));
            if (info != null) {
                if (info.output != null) {
                    adapterResult = info.output.apply(contextBus, result);
                }
                if (StringUtils.isNotEmpty((CharSequence)info.idAlias)) {
                    idTmp = info.idAlias;
                }
            }
            if (adapterResult != null) {
                contextBus.putPassResult(idTmp, adapterResult);
            } else {
                contextBus.putPassResult(idTmp, result);
            }
            ContextBus.putLastNodeId(idTmp);
        }
    }

    public abstract P doProcess(IContextBus var1);
}

