/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.context;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.salt.function.flow.Info;
import org.salt.function.flow.context.IContextBus;
import org.salt.function.flow.node.IFlowNode;
import org.salt.function.flow.thread.TheadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextBus<T, R>
implements IContextBus<T, R> {
    private static final Logger log = LoggerFactory.getLogger(ContextBus.class);
    private static String LAST_NODE_ID_KEY = "last_node_id_key";
    private T param;
    private R result;
    private ConcurrentMap<String, Object> transmitMap;
    private ConcurrentMap<String, Object> passResultMap;
    private ConcurrentMap<String, Exception> passExceptionMap;
    private ConcurrentMap<String, Object> conditionMap;
    private String flowId;
    private String runtimeId;
    private volatile boolean stopFlag;
    private boolean rollbackFlag;
    private Deque<IFlowNode> rollbackList;
    private ConcurrentMap<String, Function<IContextBus<T, R>, ?>> functionMap;

    @Override
    public T getParam() {
        return this.param;
    }

    @Override
    public R getResult() {
        return this.result;
    }

    @Override
    public void setResult(R result) {
        this.result = result;
    }

    @Override
    public <P> void putTransmitInfo(String key, P content) {
        this.transmitMap.put(key, content);
    }

    @Override
    public <P> P getTransmitInfo(String key) {
        return (P)this.transmitMap.get(key);
    }

    @Override
    public <P> void addCondition(String key, P value) {
        if (key == null || value == null) {
            return;
        }
        if (this.conditionMap.containsKey(key)) {
            log.warn("{} process addCondition param repeat. key:{}, value:{}, traceId:{}", new Object[]{this.flowId, key, value, this.runtimeId});
        }
        this.conditionMap.put(key, value);
    }

    @Override
    public Map<String, Object> getConditionMap() {
        return this.conditionMap;
    }

    @Override
    public <P> P getPassResult(String nodeId) {
        return (P)this.passResultMap.get(nodeId);
    }

    public <P> void putPassResult(String nodeId, P result) {
        this.passResultMap.put(nodeId, result);
    }

    public <P> void removePassResult(String nodeId) {
        this.passResultMap.remove(nodeId);
    }

    public static void putLastNodeId(String nodeId) {
        TheadHelper.putThreadLocal(LAST_NODE_ID_KEY, nodeId);
    }

    public static String getLastnodeId() {
        return (String)TheadHelper.getThreadLocal(LAST_NODE_ID_KEY);
    }

    public static void clean() {
        TheadHelper.clean();
    }

    public <P> P getPassResult(String nodeId, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = this.passResultMap.get(nodeId);
        if (result != null && result instanceof Future) {
            return (P)((Future)result).get(timeout, TimeUnit.MILLISECONDS);
        }
        throw new RuntimeException("node is not Future");
    }

    @Override
    public Exception getPassException(String nodeId) {
        return (Exception)this.passExceptionMap.get(nodeId);
    }

    public void putPassException(String nodeId, Exception e) {
        this.passExceptionMap.put(nodeId, e);
    }

    @Override
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    public String getRuntimeId() {
        return this.runtimeId;
    }

    @Override
    public <P> P getPreResult() {
        String nodeId = (String)TheadHelper.getThreadLocal(LAST_NODE_ID_KEY);
        if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
            log.debug("{} process getPreResult. nodeId:{}, traceId:{}", new Object[]{this.flowId, nodeId, this.runtimeId});
            return (P)this.passResultMap.get(nodeId);
        }
        return null;
    }

    public ContextBus<T, R> copy(String processId) {
        ContextBus<T, R> contextBus = ContextBus.builder().param(this.param).conditionMap(this.conditionMap).passResultMap(this.passResultMap).passExceptionMap(this.passExceptionMap).transmitMap(this.transmitMap).flowId(processId).runtimeId(this.runtimeId).rollbackList(this.rollbackList).functionMap(this.functionMap).build();
        return contextBus;
    }

    public ContextBus<T, R> copyNotify(String processId) {
        ContextBus<T, R> contextBus = ContextBus.builder().param(this.param).conditionMap(this.conditionMap).passResultMap(this.passResultMap).passExceptionMap(this.passExceptionMap).transmitMap(this.transmitMap).flowId(processId).runtimeId(this.runtimeId).rollbackList(new LinkedList<IFlowNode>()).functionMap(this.functionMap).build();
        return contextBus;
    }

    public static <T, R> ContextBus<T, R> create(String flowId, T param, Map<String, Object> conditionMap) {
        Map conditionTmp = conditionMap;
        if (conditionTmp == null) {
            try {
                if (param.getClass().isPrimitive() || param instanceof Number || param instanceof Boolean || param instanceof String) {
                    conditionTmp = new HashMap<String, Object>();
                    conditionTmp.put((String)"param", param);
                } else {
                    conditionTmp = BeanUtils.describe(param);
                    conditionTmp.entrySet().removeIf(entry -> Objects.isNull(entry.getValue()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("param to conditionMap error");
            }
        }
        ContextBus<T, R> contextBus = ContextBus.builder().param(param).conditionMap(conditionTmp != null ? new ConcurrentHashMap<String, Object>(conditionTmp) : new ConcurrentHashMap()).passResultMap(new ConcurrentHashMap<String, Object>()).passExceptionMap(new ConcurrentHashMap<String, Exception>()).transmitMap(new ConcurrentHashMap<String, Object>()).flowId(flowId).runtimeId(UUID.randomUUID().toString().replaceAll("-", "")).rollbackList(new LinkedList<IFlowNode>()).functionMap(new ConcurrentHashMap()).build();
        contextBus.putPassResult(flowId, param);
        ContextBus.clean();
        ContextBus.putLastNodeId(flowId);
        return contextBus;
    }

    @Override
    public void stopProcess() {
        this.stopFlag = true;
    }

    public boolean isStopProcess() {
        return this.stopFlag;
    }

    @Override
    public synchronized void rollbackProcess() {
        this.rollbackFlag = true;
    }

    public synchronized boolean isRollbackProcess() {
        return this.rollbackFlag;
    }

    public synchronized void roolbackAll() {
        for (int i = this.rollbackList.size() - 1; i >= 0; --i) {
            IFlowNode execNode = this.rollbackList.pop();
            try {
                execNode.rollback(this);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized boolean roolbackExec(IFlowNode iFlowNode) {
        if (this.rollbackFlag) {
            try {
                iFlowNode.rollback(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        this.rollbackList.push(iFlowNode);
        return false;
    }

    public static Info getNodeInfo(String key) {
        return (Info)TheadHelper.getThreadLocal(key);
    }

    ContextBus(T param, R result, ConcurrentMap<String, Object> transmitMap, ConcurrentMap<String, Object> passResultMap, ConcurrentMap<String, Exception> passExceptionMap, ConcurrentMap<String, Object> conditionMap, String flowId, String runtimeId, boolean stopFlag, boolean rollbackFlag, Deque<IFlowNode> rollbackList, ConcurrentMap<String, Function<IContextBus<T, R>, ?>> functionMap) {
        this.param = param;
        this.result = result;
        this.transmitMap = transmitMap;
        this.passResultMap = passResultMap;
        this.passExceptionMap = passExceptionMap;
        this.conditionMap = conditionMap;
        this.flowId = flowId;
        this.runtimeId = runtimeId;
        this.stopFlag = stopFlag;
        this.rollbackFlag = rollbackFlag;
        this.rollbackList = rollbackList;
        this.functionMap = functionMap;
    }

    public static <T, R> ContextBusBuilder<T, R> builder() {
        return new ContextBusBuilder();
    }

    public static class ContextBusBuilder<T, R> {
        private T param;
        private R result;
        private ConcurrentMap<String, Object> transmitMap;
        private ConcurrentMap<String, Object> passResultMap;
        private ConcurrentMap<String, Exception> passExceptionMap;
        private ConcurrentMap<String, Object> conditionMap;
        private String flowId;
        private String runtimeId;
        private boolean stopFlag;
        private boolean rollbackFlag;
        private Deque<IFlowNode> rollbackList;
        private ConcurrentMap<String, Function<IContextBus<T, R>, ?>> functionMap;

        ContextBusBuilder() {
        }

        public ContextBusBuilder<T, R> param(T param) {
            this.param = param;
            return this;
        }

        public ContextBusBuilder<T, R> result(R result) {
            this.result = result;
            return this;
        }

        public ContextBusBuilder<T, R> transmitMap(ConcurrentMap<String, Object> transmitMap) {
            this.transmitMap = transmitMap;
            return this;
        }

        public ContextBusBuilder<T, R> passResultMap(ConcurrentMap<String, Object> passResultMap) {
            this.passResultMap = passResultMap;
            return this;
        }

        public ContextBusBuilder<T, R> passExceptionMap(ConcurrentMap<String, Exception> passExceptionMap) {
            this.passExceptionMap = passExceptionMap;
            return this;
        }

        public ContextBusBuilder<T, R> conditionMap(ConcurrentMap<String, Object> conditionMap) {
            this.conditionMap = conditionMap;
            return this;
        }

        public ContextBusBuilder<T, R> flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public ContextBusBuilder<T, R> runtimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public ContextBusBuilder<T, R> stopFlag(boolean stopFlag) {
            this.stopFlag = stopFlag;
            return this;
        }

        public ContextBusBuilder<T, R> rollbackFlag(boolean rollbackFlag) {
            this.rollbackFlag = rollbackFlag;
            return this;
        }

        public ContextBusBuilder<T, R> rollbackList(Deque<IFlowNode> rollbackList) {
            this.rollbackList = rollbackList;
            return this;
        }

        public ContextBusBuilder<T, R> functionMap(ConcurrentMap<String, Function<IContextBus<T, R>, ?>> functionMap) {
            this.functionMap = functionMap;
            return this;
        }

        public ContextBus<T, R> build() {
            return new ContextBus<T, R>(this.param, this.result, this.transmitMap, this.passResultMap, this.passExceptionMap, this.conditionMap, this.flowId, this.runtimeId, this.stopFlag, this.rollbackFlag, this.rollbackList, this.functionMap);
        }

        public String toString() {
            return "ContextBus.ContextBusBuilder(param=" + this.param + ", result=" + this.result + ", transmitMap=" + this.transmitMap + ", passResultMap=" + this.passResultMap + ", passExceptionMap=" + this.passExceptionMap + ", conditionMap=" + this.conditionMap + ", flowId=" + this.flowId + ", runtimeId=" + this.runtimeId + ", stopFlag=" + this.stopFlag + ", rollbackFlag=" + this.rollbackFlag + ", rollbackList=" + this.rollbackList + ", functionMap=" + this.functionMap + ")";
        }
    }
}

