/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.salt.function.flow.FlowEngine;
import org.salt.function.flow.config.IFlowInit;
import org.salt.function.flow.node.register.FlowNodeManager;
import org.salt.function.flow.node.register.FlowNodeScanner;
import org.salt.function.flow.thread.IThreadContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConditionalOnBean(value={IFlowInit.class})
public class FlowConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FlowConfiguration.class);
    @Value(value="${salt.function.flow.threadpool.coreSize:100}")
    private int coreSize;
    @Value(value="${salt.function.flow.threadpool.maxSize:300}")
    private int maxSize;
    @Value(value="${salt.function.flow.threadpool.queueCapacity:1024}")
    private int queueCapacity;
    @Value(value="${salt.function.flow.threadpool.keepAlive:60}")
    private int keepAlive;

    @Bean
    public FlowNodeManager register() {
        return new FlowNodeManager();
    }

    @Bean(initMethod="init")
    public FlowNodeScanner extensionScanner(FlowNodeManager flowNodeManager) {
        return new FlowNodeScanner(flowNodeManager);
    }

    @Bean
    @ConditionalOnMissingBean(name={"flowThreadPool"})
    public ThreadPoolTaskExecutor flowThreadPool() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.coreSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.maxSize);
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity);
        threadPoolTaskExecutor.setKeepAliveSeconds(this.keepAlive);
        threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        threadPoolTaskExecutor.setThreadNamePrefix("thread-pool-flow-");
        threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> threadPoolTaskExecutor.shutdown()));
        return threadPoolTaskExecutor;
    }

    @Bean
    public FlowEngine flowEngine(FlowNodeManager flowNodeManager, @Autowired(required=false) IFlowInit flowInit, ThreadPoolTaskExecutor flowThreadPool, @Autowired(required=false) IThreadContent threadContent) {
        return new FlowEngine(flowNodeManager, flowInit, flowThreadPool, threadContent);
    }
}

