/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow;

import java.util.List;
import java.util.Map;
import org.salt.function.flow.FlowEngine;
import org.salt.function.flow.context.ContextBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class FlowInstance {
    private static final Logger log = LoggerFactory.getLogger(FlowInstance.class);
    protected String flowId;
    private List<String> nodeList;
    private FlowEngine flowEngine;

    protected FlowInstance() {
    }

    protected FlowInstance(String flowId, List<String> nodeList, FlowEngine flowEngine) {
        this.flowId = flowId;
        this.nodeList = nodeList;
        this.flowEngine = flowEngine;
    }

    protected <T, R> R execute(T param, Map<String, Object> transmitMap, Map<String, Object> conditionMap) {
        ContextBus contextBus = ContextBus.create(this.flowId, param, conditionMap);
        if (transmitMap != null && !transmitMap.isEmpty()) {
            transmitMap.forEach((k, v) -> contextBus.putTransmitInfo((String)k, v));
        }
        return this.execute(contextBus);
    }

    protected <T, R> R execute(ContextBus<T, R> contextBus) {
        if (!CollectionUtils.isEmpty(this.nodeList)) {
            for (String nodeId : this.nodeList) {
                this.flowEngine.flowNodeManager.executeVoidSingle(contextBus, nodeId);
                if (contextBus.isRollbackProcess()) {
                    contextBus.roolbackAll();
                    break;
                }
                if (!contextBus.isStopProcess()) continue;
                break;
            }
            return contextBus.getResult();
        }
        throw new RuntimeException("processInstance node list is empty.");
    }
}

