/*
 * Decompiled with CFR 0.152.
 */
package org.salt.function.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.salt.function.flow.FlowInstance;
import org.salt.function.flow.Info;
import org.salt.function.flow.config.IFlowInit;
import org.salt.function.flow.context.ContextBus;
import org.salt.function.flow.context.IContextBus;
import org.salt.function.flow.node.FlowNode;
import org.salt.function.flow.node.IResult;
import org.salt.function.flow.node.register.FlowNodeManager;
import org.salt.function.flow.node.structure.FlowNodeStructure;
import org.salt.function.flow.node.structure.internal.FlowNodeAll;
import org.salt.function.flow.node.structure.internal.FlowNodeConcurrent;
import org.salt.function.flow.node.structure.internal.FlowNodeFuture;
import org.salt.function.flow.node.structure.internal.FlowNodeNext;
import org.salt.function.flow.node.structure.internal.FlowNodeNotify;
import org.salt.function.flow.node.structure.internal.FlowNodeResult;
import org.salt.function.flow.node.structure.internal.FlowNodeWait;
import org.salt.function.flow.thread.IThreadContent;
import org.salt.function.flow.thread.TheadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;

public class FlowEngine
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(FlowEngine.class);
    protected FlowNodeManager flowNodeManager;
    protected IFlowInit flowInit;
    protected ThreadPoolTaskExecutor flowThreadPool;
    protected IThreadContent threadContent;
    private static ConcurrentMap<String, FlowInstance> processInstanceMap = new ConcurrentHashMap<String, FlowInstance>();

    public FlowEngine(FlowNodeManager flowNodeManager, IFlowInit flowInit, ThreadPoolTaskExecutor flowThreadPool, IThreadContent threadContent) {
        this.flowNodeManager = flowNodeManager;
        this.flowInit = flowInit;
        this.flowThreadPool = flowThreadPool;
        this.threadContent = threadContent;
    }

    public void afterPropertiesSet() {
        if (this.flowInit != null) {
            this.flowInit.configure(this);
        }
    }

    public <T, R> R execute(String flowId, T param) {
        return this.execute(flowId, param, null);
    }

    public <T, R> R execute(String flowId, T param, Map<String, Object> conditionMap) {
        return this.execute(flowId, param, conditionMap, null);
    }

    public <T, R> R execute(String flowId, T param, Map<String, Object> conditionMap, Map<String, Object> transmitMap) {
        FlowInstance flowInstance = (FlowInstance)processInstanceMap.get(flowId);
        if (flowInstance != null) {
            return flowInstance.execute(param, transmitMap, conditionMap);
        }
        throw new RuntimeException("no have this process");
    }

    public <T, R> R execute(FlowInstance flowInstance, T param) {
        return this.execute(flowInstance, param, null);
    }

    public <T, R> R execute(FlowInstance flowInstance, T param, Map<String, Object> transmitMap) {
        return flowInstance.execute(param, transmitMap, null);
    }

    public <T, R> R execute(FlowInstance flowInstance, T param, Map<String, Object> transmitMap, Map<String, Object> conditionMap) {
        return flowInstance.execute(param, transmitMap, conditionMap);
    }

    public <T, R> R execute(ContextBus<T, R> contextBus) {
        FlowInstance flowInstance = (FlowInstance)processInstanceMap.get(contextBus.getFlowId());
        if (flowInstance != null) {
            return flowInstance.execute(contextBus);
        }
        throw new RuntimeException("no have this process");
    }

    public <T, R> R executeBranch(IContextBus<T, R> iContextBus, String id) {
        ContextBus contextBusChild = ((ContextBus)iContextBus).copy(id);
        Object result = this.execute(contextBusChild);
        if (contextBusChild.isRollbackProcess()) {
            iContextBus.rollbackProcess();
        }
        if (contextBusChild.isStopProcess()) {
            iContextBus.stopProcess();
        }
        return result;
    }

    public <T, R> R executeBranchVoid(IContextBus<T, R> iContextBus, String id) {
        R result = this.executeBranch(iContextBus, id);
        if (result != null) {
            ((ContextBus)iContextBus).putPassResult(id, result);
        }
        return result;
    }

    public Builder builder() {
        return new Builder(this);
    }

    public Builder branch() {
        String flowId = "branch-" + UUID.randomUUID().toString().replaceAll("-", "");
        return new Builder(this).id(flowId);
    }

    public static class InitParam {
        private static long MAP_WAIT_TIMEOUT = 3000L;
        String id;
        String idTmp;
        long timeout;
        IResult result;
        ExecutorService isolate;
        Info[] infos;

        private static String $default$idTmp() {
            return "";
        }

        private static long $default$timeout() {
            return MAP_WAIT_TIMEOUT;
        }

        InitParam(String id, String idTmp, long timeout, IResult result, ExecutorService isolate, Info[] infos) {
            this.id = id;
            this.idTmp = idTmp;
            this.timeout = timeout;
            this.result = result;
            this.isolate = isolate;
            this.infos = infos;
        }

        public static InitParamBuilder builder() {
            return new InitParamBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getIdTmp() {
            return this.idTmp;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public IResult getResult() {
            return this.result;
        }

        public ExecutorService getIsolate() {
            return this.isolate;
        }

        public Info[] getInfos() {
            return this.infos;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setIdTmp(String idTmp) {
            this.idTmp = idTmp;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public void setResult(IResult result) {
            this.result = result;
        }

        public void setIsolate(ExecutorService isolate) {
            this.isolate = isolate;
        }

        public void setInfos(Info[] infos) {
            this.infos = infos;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitParam)) {
                return false;
            }
            InitParam other = (InitParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimeout() != other.getTimeout()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$idTmp = this.getIdTmp();
            String other$idTmp = other.getIdTmp();
            if (this$idTmp == null ? other$idTmp != null : !this$idTmp.equals(other$idTmp)) {
                return false;
            }
            IResult this$result = this.getResult();
            IResult other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            ExecutorService this$isolate = this.getIsolate();
            ExecutorService other$isolate = other.getIsolate();
            if (this$isolate == null ? other$isolate != null : !this$isolate.equals(other$isolate)) {
                return false;
            }
            return Arrays.deepEquals(this.getInfos(), other.getInfos());
        }

        protected boolean canEqual(Object other) {
            return other instanceof InitParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timeout = this.getTimeout();
            result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $idTmp = this.getIdTmp();
            result = result * 59 + ($idTmp == null ? 43 : $idTmp.hashCode());
            IResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            ExecutorService $isolate = this.getIsolate();
            result = result * 59 + ($isolate == null ? 43 : $isolate.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getInfos());
            return result;
        }

        public String toString() {
            return "FlowEngine.InitParam(id=" + this.getId() + ", idTmp=" + this.getIdTmp() + ", timeout=" + this.getTimeout() + ", result=" + this.getResult() + ", isolate=" + this.getIsolate() + ", infos=" + Arrays.deepToString(this.getInfos()) + ")";
        }

        public static class InitParamBuilder {
            private String id;
            private boolean idTmp$set;
            private String idTmp$value;
            private boolean timeout$set;
            private long timeout$value;
            private IResult result;
            private ExecutorService isolate;
            private Info[] infos;

            InitParamBuilder() {
            }

            public InitParamBuilder id(String id) {
                this.id = id;
                return this;
            }

            public InitParamBuilder idTmp(String idTmp) {
                this.idTmp$value = idTmp;
                this.idTmp$set = true;
                return this;
            }

            public InitParamBuilder timeout(long timeout) {
                this.timeout$value = timeout;
                this.timeout$set = true;
                return this;
            }

            public InitParamBuilder result(IResult result) {
                this.result = result;
                return this;
            }

            public InitParamBuilder isolate(ExecutorService isolate) {
                this.isolate = isolate;
                return this;
            }

            public InitParamBuilder infos(Info[] infos) {
                this.infos = infos;
                return this;
            }

            public InitParam build() {
                String idTmp$value = this.idTmp$value;
                if (!this.idTmp$set) {
                    idTmp$value = InitParam.$default$idTmp();
                }
                long timeout$value = this.timeout$value;
                if (!this.timeout$set) {
                    timeout$value = InitParam.$default$timeout();
                }
                return new InitParam(this.id, idTmp$value, timeout$value, this.result, this.isolate, this.infos);
            }

            public String toString() {
                return "FlowEngine.InitParam.InitParamBuilder(id=" + this.id + ", idTmp$value=" + this.idTmp$value + ", timeout$value=" + this.timeout$value + ", result=" + this.result + ", isolate=" + this.isolate + ", infos=" + Arrays.deepToString(this.infos) + ")";
            }
        }
    }

    public static class Builder {
        String flowId;
        List<String> idList;
        private FlowEngine flowEngine;

        public Builder(FlowEngine flowEngine) {
            this.flowEngine = flowEngine;
            this.idList = new ArrayList<String>();
        }

        public Builder id(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public Builder next(String ... ids) {
            return this.next(this.toInfos(ids));
        }

        public Builder next(Info ... infos) {
            return this.next(InitParam.builder().infos(infos).build());
        }

        public Builder next(IResult result, Info ... infos) {
            return this.next(InitParam.builder().infos(infos).result(result).build());
        }

        private Builder next(InitParam initParam) {
            this.init(this.tempName("next", initParam.idTmp), new FlowNodeNext(), initParam);
            return this;
        }

        public Builder all(String ... ids) {
            return this.all(this.toInfos(ids));
        }

        public Builder all(IResult result, String ... ids) {
            return this.all(result, this.toInfos(ids));
        }

        public Builder all(Info ... infos) {
            return this.all(InitParam.builder().infos(infos).build());
        }

        public Builder all(IResult result, Info ... infos) {
            return this.all(InitParam.builder().infos(infos).result(result).build());
        }

        private Builder all(InitParam initParam) {
            this.init(this.tempName("all", initParam.idTmp), new FlowNodeAll(), initParam);
            return this;
        }

        public Builder concurrent(String ... ids) {
            return this.concurrent(this.toInfos(ids));
        }

        public Builder concurrent(long timeout, String ... ids) {
            return this.concurrent(timeout, this.toInfos(ids));
        }

        public Builder concurrent(IResult result, String ... ids) {
            return this.concurrent(result, this.toInfos(ids));
        }

        public Builder concurrent(IResult result, long timeout, String ... ids) {
            return this.concurrent(result, timeout, this.toInfos(ids));
        }

        public Builder concurrent(IResult result, ExecutorService isolate, String ... ids) {
            return this.concurrent(result, isolate, this.toInfos(ids));
        }

        public Builder concurrent(IResult result, long timeout, ExecutorService isolate, String ... ids) {
            return this.concurrent(result, timeout, isolate, this.toInfos(ids));
        }

        public Builder concurrent(Info ... infos) {
            return this.concurrent(InitParam.builder().infos(infos).build());
        }

        public Builder concurrent(long timeout, Info ... infos) {
            return this.concurrent(InitParam.builder().infos(infos).timeout(timeout).build());
        }

        public Builder concurrent(IResult result, Info ... infos) {
            return this.concurrent(InitParam.builder().infos(infos).result(result).build());
        }

        public Builder concurrent(IResult result, long timeout, Info ... infos) {
            return this.concurrent(InitParam.builder().infos(infos).result(result).timeout(timeout).build());
        }

        public Builder concurrent(IResult result, ExecutorService isolate, Info ... infos) {
            return this.concurrent(InitParam.builder().infos(infos).result(result).isolate(isolate).build());
        }

        public Builder concurrent(IResult result, long timeout, ExecutorService isolate, Info ... infos) {
            return this.concurrent(InitParam.builder().infos(infos).result(result).timeout(timeout).isolate(isolate).build());
        }

        private Builder concurrent(InitParam initParam) {
            this.init(this.tempName("concurrent", initParam.idTmp), new FlowNodeConcurrent(), initParam);
            return this;
        }

        public Builder notify(String ... ids) {
            return this.notify(this.toInfos(ids));
        }

        public Builder notify(ExecutorService isolate, String ... ids) {
            return this.notify(isolate, this.toInfos(ids));
        }

        public Builder notify(Info ... infos) {
            return this.notify(InitParam.builder().infos(infos).build());
        }

        public Builder notify(ExecutorService isolate, Info ... infos) {
            return this.notify(InitParam.builder().infos(infos).isolate(isolate).build());
        }

        private Builder notify(InitParam initParam) {
            this.init(this.tempName("notify", initParam.idTmp), new FlowNodeNotify(), initParam);
            return this;
        }

        public Builder future(String ... ids) {
            return this.future(this.toInfos(ids));
        }

        public Builder future(ExecutorService isolate, String ... ids) {
            return this.future(isolate, this.toInfos(ids));
        }

        public Builder future(Info ... infos) {
            return this.future(InitParam.builder().infos(infos).build());
        }

        public Builder future(ExecutorService isolate, Info ... infos) {
            return this.future(InitParam.builder().infos(infos).isolate(isolate).build());
        }

        private Builder future(InitParam initParam) {
            this.init(this.tempName("future", initParam.idTmp), new FlowNodeFuture(), initParam);
            return this;
        }

        public Builder wait(String ... ids) {
            return this.wait(this.toInfos(ids));
        }

        public Builder wait(IResult result, String ... ids) {
            return this.wait(result, this.toInfos(ids));
        }

        public Builder wait(long timeout, String ... ids) {
            return this.wait(timeout, this.toInfos(ids));
        }

        public Builder wait(IResult result, long timeout, String ... ids) {
            return this.wait(result, timeout, this.toInfos(ids));
        }

        public Builder wait(Info ... infos) {
            return this.wait(InitParam.builder().infos(infos).build());
        }

        public Builder wait(IResult result, Info ... infos) {
            return this.wait(InitParam.builder().infos(infos).result(result).build());
        }

        public Builder wait(long timeout, Info ... infos) {
            return this.wait(InitParam.builder().infos(infos).timeout(timeout).build());
        }

        public Builder wait(IResult result, long timeout, Info ... infos) {
            return this.wait(InitParam.builder().infos(infos).result(result).timeout(timeout).build());
        }

        private Builder wait(InitParam initParam) {
            this.init(this.tempName("wait", initParam.idTmp), new FlowNodeWait(), initParam);
            return this;
        }

        public Builder result(String nodeId) {
            return this.result(InitParam.builder().id(nodeId).build());
        }

        private Builder result(InitParam initParam) {
            FlowNodeResult flowNodeResult = new FlowNodeResult();
            flowNodeResult.getNodeIdResult(initParam.id);
            this.init(this.tempName("result", initParam.idTmp), flowNodeResult, initParam);
            return this;
        }

        public String build() {
            this.check();
            if (processInstanceMap.containsKey(this.flowId)) {
                throw new RuntimeException("flow already exists. flowId:" + this.flowId);
            }
            processInstanceMap.put(this.flowId, new FlowInstance(this.flowId, this.idList, this.flowEngine));
            return this.flowId;
        }

        public FlowInstance buildDynamic() {
            this.check();
            return new FlowInstance(this.flowId, this.idList, this.flowEngine);
        }

        private void check() {
            if (StringUtils.isEmpty((CharSequence)this.flowId)) {
                throw new RuntimeException("flow flowId is empty.");
            }
            if (CollectionUtils.isEmpty(this.idList)) {
                throw new RuntimeException("flow node list is empty.");
            }
        }

        private String tempName(String type, String idTmp) {
            if (StringUtils.isNotEmpty((CharSequence)idTmp)) {
                return idTmp;
            }
            return StringUtils.join((Object[])new String[]{type, "-", UUID.randomUUID().toString().replaceAll("-", "")});
        }

        private Info[] toInfos(String ... ids) {
            return Arrays.stream(ids).map(id -> Info.builder().id((String)id).build()).collect(Collectors.toList()).toArray(new Info[ids.length]);
        }

        private void init(String id, FlowNode flowNode, InitParam initParam) {
            flowNode.setNodeId(id);
            if (flowNode instanceof FlowNodeStructure) {
                FlowNodeStructure flowNodeStructure = (FlowNodeStructure)flowNode;
                flowNodeStructure.setFlowEngine(this.flowEngine);
                flowNodeStructure.setFlowNodeManager(this.flowEngine.flowNodeManager);
                flowNodeStructure.setResult(initParam.result);
                flowNodeStructure.setTheadHelper(this.creatThreadHelper(initParam));
                if (initParam.infos != null) {
                    flowNodeStructure.setNodeInfoList(Arrays.asList(initParam.infos));
                }
            }
            this.flowEngine.flowNodeManager.doRegistration(flowNode);
            this.idList.add(id);
        }

        private TheadHelper creatThreadHelper(InitParam initParam) {
            return TheadHelper.builder().timeout(initParam.timeout).threadContent(this.flowEngine.threadContent).executor(initParam.isolate != null ? initParam.isolate : this.flowEngine.flowThreadPool.getThreadPoolExecutor()).build();
        }
    }
}

