/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.api.direct;

import cn.felord.payment.wechat.v3.api.direct.DirectBasePayApi;
import cn.felord.payment.wechat.v3.api.direct.MarketingBusiFavorApi;
import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.retrofit.InMemoryTenpayKeyCache;
import cn.felord.payment.wechat.v3.retrofit.TenpayKeyCache;
import cn.felord.payment.wechat.v3.retrofit.WechatPayRetrofitFactory;
import okhttp3.ConnectionPool;
import okhttp3.logging.HttpLoggingInterceptor;

public final class WechatPayApi {
    private final WechatPayRetrofitFactory factory;

    private WechatPayApi(WechatPayRetrofitFactory factory) {
        this.factory = factory;
    }

    public DirectBasePayApi directBasePayApi(AppMerchant appMerchant) {
        return new DirectBasePayApi(this.factory, appMerchant);
    }

    public MarketingBusiFavorApi busiFavorApi(AppMerchant appMerchant) {
        return (MarketingBusiFavorApi)this.factory.app(appMerchant).create(MarketingBusiFavorApi.class);
    }

    public static class Builder {
        private static final String DEFAULT_BASE_URL = "https://api.mch.weixin.qq.com/";
        private String baseUrl = "https://api.mch.weixin.qq.com/";
        private TenpayKeyCache tenpayKeyCache = new InMemoryTenpayKeyCache();
        private ConnectionPool connectionPool = new ConnectionPool();
        private HttpLoggingInterceptor.Level logLevel = HttpLoggingInterceptor.Level.NONE;

        public Builder tenpayKeyCache(TenpayKeyCache tenpayKeyCache) {
            this.tenpayKeyCache = tenpayKeyCache;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder connectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public Builder logLevel(HttpLoggingInterceptor.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public WechatPayApi build() {
            WechatPayRetrofitFactory retrofitFactory = new WechatPayRetrofitFactory(this.baseUrl, this.tenpayKeyCache, this.connectionPool, this.logLevel);
            return new WechatPayApi(retrofitFactory);
        }
    }
}

