/*
 *  Copyright (c) 2023. felord.cn
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *       https://www.apache.org/licenses/LICENSE-2.0
 *  Website:
 *       https://felord.cn
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package cn.felord.payment.wechat.enumeration;

/**
 * The enum Business cert type.
 *
 * @author dax
 * @since 2023 /7/1 8:34
 */
public enum BusinessCertType {
    /**
     * 事业单位法人证书
     */
    CERTIFICATE_TYPE_2388,

    /**
     * 统一社会信用代码证书
     */
    CERTIFICATE_TYPE_2389,

    /**
     * 社会团体法人登记证书
     */
    CERTIFICATE_TYPE_2394,
    /**
     * 民办非企业单位登记证书
     */
    CERTIFICATE_TYPE_2395,

    /**
     * 基金会法人登记证书
     */
    CERTIFICATE_TYPE_2396,
    /**
     * 宗教活动场所登记证
     */
    CERTIFICATE_TYPE_2399,

    /**
     * 政府部门下发的其他有效证明文件
     */
    CERTIFICATE_TYPE_2400,
    /**
     * 执业许可证/执业证
     */
    CERTIFICATE_TYPE_2520,
    /**
     * 基层群众性自治组织特别法人统一社会信用代码证
     */
    CERTIFICATE_TYPE_2521,
    /**
     * 农村集体经济组织登记证
     */
    CERTIFICATE_TYPE_2522
}
