/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.retrofit;

import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.retrofit.ResponseBodyCallAdapterFactory;
import cn.felord.payment.wechat.v3.retrofit.TenpayCertificateService;
import cn.felord.payment.wechat.v3.retrofit.TenpayKeyCache;
import cn.felord.payment.wechat.v3.retrofit.WechatAuthorizationInterceptor;
import cn.felord.retrofit.json.JsonConverterFactory;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;

public final class WechatPayRetrofitFactory {
    private static final String DEFAULT_BASE_URL = "https://api.mch.weixin.qq.com/";
    private final String baseUrl;
    private final TenpayKeyCache tenpayKeyCache;
    private final ConnectionPool connectionPool;
    private final HttpLoggingInterceptor.Level level;

    public WechatPayRetrofitFactory(TenpayKeyCache tenpayKeyCache) {
        this(DEFAULT_BASE_URL, tenpayKeyCache);
    }

    public WechatPayRetrofitFactory(String baseUrl, TenpayKeyCache tenpayKeyCache) {
        this(baseUrl, tenpayKeyCache, new ConnectionPool(), HttpLoggingInterceptor.Level.NONE);
    }

    public WechatPayRetrofitFactory(String baseUrl, TenpayKeyCache tenpayKeyCache, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        this.baseUrl = baseUrl;
        this.tenpayKeyCache = tenpayKeyCache;
        this.connectionPool = connectionPool;
        this.level = level;
    }

    public Retrofit app(AppMerchant appMerchant) {
        return new Retrofit.Builder().baseUrl(this.baseUrl).client(WechatPayRetrofitFactory.okHttpClient(this.baseUrl, appMerchant, this.tenpayKeyCache, this.connectionPool, this.level)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)ResponseBodyCallAdapterFactory.INSTANCE).addConverterFactory((Converter.Factory)JsonConverterFactory.create()).build();
    }

    public static Retrofit withNoAuth() {
        return new Retrofit.Builder().baseUrl(DEFAULT_BASE_URL).client(WechatPayRetrofitFactory.okHttpClient(new ConnectionPool(), HttpLoggingInterceptor.Level.NONE)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)ResponseBodyCallAdapterFactory.INSTANCE).addConverterFactory((Converter.Factory)JsonConverterFactory.create()).build();
    }

    private static OkHttpClient okHttpClient(ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.level(level);
        return new OkHttpClient.Builder().connectionPool(connectionPool).addInterceptor((Interceptor)httpLoggingInterceptor).retryOnConnectionFailure(true).connectTimeout(20L, TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS).writeTimeout(120L, TimeUnit.SECONDS).build();
    }

    private static OkHttpClient okHttpClient(String baseUrl, AppMerchant appMerchant, TenpayKeyCache tenpayKeyCache, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.level(level);
        TenpayCertificateService tenpayCertificateService = new TenpayCertificateService(baseUrl, appMerchant, tenpayKeyCache);
        WechatAuthorizationInterceptor authorizationInterceptor = new WechatAuthorizationInterceptor(appMerchant, tenpayCertificateService);
        return new OkHttpClient.Builder().connectionPool(connectionPool).addInterceptor((Interceptor)authorizationInterceptor).addInterceptor((Interceptor)httpLoggingInterceptor).retryOnConnectionFailure(true).connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
    }
}

