/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.retrofit;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.crypto.TenpayKey;
import cn.felord.payment.wechat.v3.crypto.WechatPaySigner;
import cn.felord.payment.wechat.v3.retrofit.AbstractAuthorizationInterceptor;
import cn.felord.payment.wechat.v3.retrofit.HttpHeaders;
import cn.felord.payment.wechat.v3.retrofit.TenpayCertificateService;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

class WechatAuthorizationInterceptor
extends AbstractAuthorizationInterceptor {
    private final TenpayCertificateService tenpayCertificateService;

    WechatAuthorizationInterceptor(AppMerchant appMerchant, TenpayCertificateService tenpayCertificateService) {
        super(appMerchant);
        this.tenpayCertificateService = tenpayCertificateService;
    }

    @Override
    protected void verifyResponse(Response response) throws PayException {
        String s = response.request().url().encodedPath();
        String body = Optional.ofNullable(response.body()).map(ResponseBody::source).map(BufferedSource::getBuffer).map(Buffer::clone).map(Buffer::readUtf8).orElse("");
        Headers responseHeaders = response.headers();
        if (!response.isSuccessful()) {
            String requestId = responseHeaders.get(HttpHeaders.REQUEST_ID.headerName());
            String errorMessage = " Code: " + response.code() + "\n Request-ID: " + requestId + "\n Message: " + response.message() + "\n Body: " + body;
            throw new PayException(errorMessage);
        }
        String serialNumber = responseHeaders.get(HttpHeaders.WECHAT_PAY_SERIAL.headerName());
        TenpayKey tenpayKey = this.tenpayCertificateService.getTenpayKey(serialNumber);
        if (!WechatPaySigner.verify(responseHeaders, body, tenpayKey)) {
            String requestId = responseHeaders.get(HttpHeaders.REQUEST_ID.headerName());
            throw new PayException("Wechat pay signature verify failed, Request-ID: " + requestId);
        }
    }
}

