/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.domain.direct.basepay;

import cn.felord.payment.wechat.v3.domain.direct.basepay.Amount;
import cn.felord.payment.wechat.v3.domain.direct.basepay.Detail;
import cn.felord.payment.wechat.v3.domain.direct.basepay.PayParams;
import cn.felord.payment.wechat.v3.domain.direct.basepay.Payer;
import cn.felord.payment.wechat.v3.domain.direct.basepay.SceneInfo;
import cn.felord.payment.wechat.v3.domain.direct.basepay.SettleInfo;
import java.time.OffsetDateTime;

public class JsPayRequest {
    private final String notifyUrl;
    private final String description;
    private final String outTradeNo;
    private final Amount amount;
    private final Payer payer;
    private OffsetDateTime timeExpire;
    private String attach;
    private String goodsTag;
    private Detail detail;
    private Boolean supportFapiao;
    private SceneInfo sceneInfo;
    private SettleInfo settleInfo;

    public JsPayRequest(String notifyUrl, String description, String outTradeNo, long total, String openid) {
        this.notifyUrl = notifyUrl;
        this.description = description;
        this.outTradeNo = outTradeNo;
        this.amount = new Amount(total);
        this.payer = new Payer(openid);
    }

    public JsPayRequest timeExpire(OffsetDateTime timeExpire) {
        this.timeExpire = timeExpire;
        return this;
    }

    public JsPayRequest attach(String attach) {
        this.attach = attach;
        return this;
    }

    public JsPayRequest goodsTag(String goodsTag) {
        this.goodsTag = goodsTag;
        return this;
    }

    public JsPayRequest detail(Detail detail) {
        this.detail = detail;
        return this;
    }

    public JsPayRequest supportFapiao(boolean supportFapiao) {
        this.supportFapiao = supportFapiao;
        return this;
    }

    public JsPayRequest sceneInfo(SceneInfo sceneInfo) {
        this.sceneInfo = sceneInfo;
        return this;
    }

    public JsPayRequest settleInfo(SettleInfo settleInfo) {
        this.settleInfo = settleInfo;
        return this;
    }

    public PayParams toPayParams(String appid, String mchid) {
        return new PayParams(appid, mchid, this.notifyUrl, this.description, this.outTradeNo, this.amount, this.payer, this.timeExpire, this.attach, this.goodsTag, this.detail, this.supportFapiao, this.sceneInfo, this.settleInfo);
    }
}

