/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.crypto;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.crypto.AuthType;
import cn.felord.payment.wechat.v3.crypto.TenpayKey;
import cn.felord.payment.wechat.v3.retrofit.HttpHeaders;
import cn.felord.utils.AlternativeJdkIdGenerator;
import cn.felord.utils.Base64Utils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.Headers;

public final class WechatPaySigner {
    private static final String TOKEN_PATTERN = "mchid=\"%s\",nonce_str=\"%s\",timestamp=\"%d\",serial_no=\"%s\",signature=\"%s\"";
    private static final AlternativeJdkIdGenerator ID_GENERATOR = new AlternativeJdkIdGenerator();

    private WechatPaySigner() {
    }

    public static String sign(AppMerchant appMerchant, URI uri, String httpMethod, String body) {
        String canonicalUrl = Optional.ofNullable(uri.getRawQuery()).map(query -> uri.getRawPath().concat("?").concat((String)query)).orElse(uri.getRawPath());
        String nonceStr = ID_GENERATOR.generate32();
        long timestamp = Instant.now().getEpochSecond();
        String signMessage = WechatPaySigner.buildSignMessage(httpMethod, canonicalUrl, String.valueOf(timestamp), nonceStr, body);
        AuthType authType = appMerchant.authType();
        Signature signer = Signature.getInstance(authType.alg());
        signer.initSign(appMerchant.privateKey());
        signer.update(signMessage.getBytes(StandardCharsets.UTF_8));
        String encoded = Base64Utils.encodeToString((byte[])signer.sign());
        String token = String.format(TOKEN_PATTERN, appMerchant.merchantId(), nonceStr, timestamp, appMerchant.serialNumber(), encoded);
        return authType.toAuthHeader(token);
    }

    public static String sign(AppMerchant appMerchant, String ... orderedComponents) {
        String signMessage = WechatPaySigner.buildSignMessage(orderedComponents);
        AuthType authType = appMerchant.authType();
        Signature signer = Signature.getInstance(authType.alg());
        signer.initSign(appMerchant.privateKey());
        signer.update(signMessage.getBytes(StandardCharsets.UTF_8));
        return Base64Utils.encodeToString((byte[])signer.sign());
    }

    public static boolean verify(Headers responseHeaders, String body, TenpayKey tenpayKey) {
        String wechatpaySignature = Objects.requireNonNull(responseHeaders.get(HttpHeaders.WECHAT_PAY_SIGNATURE.headerName()));
        String wechatpaySignatureType = responseHeaders.get(HttpHeaders.WECHAT_PAY_SIGNATURE_TYPE.headerName());
        String wechatpayTimestamp = responseHeaders.get(HttpHeaders.WECHAT_PAY_TIMESTAMP.headerName());
        String wechatpayNonce = responseHeaders.get(HttpHeaders.WECHAT_PAY_NONCE.headerName());
        String message = WechatPaySigner.buildSignMessage(wechatpayTimestamp, wechatpayNonce, body);
        AuthType authType = AuthType.fromSignType(wechatpaySignatureType);
        try {
            Signature signer = Signature.getInstance(authType.alg());
            signer.initVerify(tenpayKey.toPublicKey());
            signer.update(message.getBytes(StandardCharsets.UTF_8));
            return signer.verify(Base64Utils.decodeFromString((String)wechatpaySignature));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new PayException("Signature verification failed", e);
        }
    }

    private static String buildSignMessage(String ... components) {
        return Arrays.stream(components).collect(Collectors.joining("\n", "", "\n"));
    }
}

