/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.crypto;

import cn.felord.payment.PayException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;

public class TenpayKey {
    private final String merchantId;
    private final String serialNumber;
    private final JWK tenPayJwk;

    @JsonCreator
    TenpayKey(@JsonProperty(value="merchantId") String merchantId, @JsonProperty(value="serialNumber") String serialNumber, @JsonProperty(value="tenPayJwk") String jsonJwk) {
        this.merchantId = merchantId;
        this.serialNumber = serialNumber;
        this.tenPayJwk = JWK.parse((String)jsonJwk);
    }

    public TenpayKey(String merchantId, String serialNumber, JWK tenPayJwk) {
        this.merchantId = merchantId;
        this.serialNumber = serialNumber;
        this.tenPayJwk = tenPayJwk;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getTenPayJwk() {
        return this.tenPayJwk.toJSONString();
    }

    public PublicKey toPublicKey() {
        try {
            if (Objects.equals(KeyType.RSA, this.tenPayJwk.getKeyType())) {
                return this.tenPayJwk.toRSAKey().toPublicKey();
            }
            throw new PayException("Not Support KeyType");
        }
        catch (JOSEException e) {
            throw new PayException("Fail to load key", e);
        }
    }

    public boolean expired() {
        return this.tenPayJwk.getExpirationTime().before(Date.from(Instant.now()));
    }

    public String toString() {
        return "TenpayKey{merchantId=" + this.merchantId + ", serialNumber=" + this.serialNumber + ", tenPayJwk=[PROTECTED]" + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenpayKey tenpayKey = (TenpayKey)o;
        if (!Objects.equals(this.merchantId, tenpayKey.merchantId)) {
            return false;
        }
        return Objects.equals(this.serialNumber, tenpayKey.serialNumber);
    }

    public int hashCode() {
        int result = this.merchantId != null ? this.merchantId.hashCode() : 0;
        result = 31 * result + (this.serialNumber != null ? this.serialNumber.hashCode() : 0);
        return result;
    }
}

