/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.crypto;

import cn.felord.payment.wechat.v3.crypto.CipherAlg;
import cn.felord.payment.wechat.v3.crypto.WecomCipher;
import cn.felord.utils.Assert;
import cn.felord.utils.Base64Utils;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DefaultWecomCipher
implements WecomCipher {
    private final CipherAlg cipherAlg;

    DefaultWecomCipher(CipherAlg cipherAlg) {
        this.cipherAlg = cipherAlg;
    }

    @Override
    public String encrypt(String key, String associatedData, String iv, String plainText) throws IllegalArgumentException {
        Assert.hasText((String)key, (String)"key is invalid");
        Assert.hasText((String)associatedData, (String)"associatedData is invalid");
        Assert.hasText((String)iv, (String)"iv is invalid");
        Assert.hasText((String)plainText, (String)"plainText is invalid");
        try {
            Cipher cipher = Cipher.getInstance(this.cipherAlg.transformation());
            cipher.init(1, (Key)new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), this.cipherAlg.alg()), new GCMParameterSpec(this.cipherAlg.tagLength(), iv.getBytes(StandardCharsets.UTF_8)));
            cipher.updateAAD(associatedData.getBytes(StandardCharsets.UTF_8));
            return Base64Utils.encodeToString((byte[])cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Error When Encrypt", e);
        }
    }

    @Override
    public String decrypt(String key, String associatedData, String iv, String cipherText) throws IllegalArgumentException {
        Assert.hasText((String)key, (String)"key is invalid");
        Assert.hasText((String)associatedData, (String)"associatedData is invalid");
        Assert.hasText((String)iv, (String)"iv is invalid");
        Assert.hasText((String)cipherText, (String)"cipherText is invalid");
        try {
            Cipher cipher = Cipher.getInstance(this.cipherAlg.transformation());
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), this.cipherAlg.alg());
            GCMParameterSpec spec = new GCMParameterSpec(this.cipherAlg.tagLength(), iv.getBytes(StandardCharsets.UTF_8));
            cipher.init(2, (Key)keySpec, spec);
            cipher.updateAAD(associatedData.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = cipher.doFinal(Base64Utils.decodeFromString((String)cipherText));
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Error When Decrypt", e);
        }
    }
}

