/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.crypto;

import cn.felord.payment.PayException;
import java.util.Arrays;
import java.util.Objects;

public enum AuthType {
    SHA256_RSA2048("SHA256withRSA", "WECHATPAY2-SHA256-RSA2048", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding"),
    SM2_WITH_SM3("SM2", "WECHATPAY2-SM2-WITH-SM3", "SM2");

    private final String alg;
    private final String signType;
    private final String transformation;

    private AuthType(String alg, String signType, String transformation) {
        this.alg = alg;
        this.signType = signType;
        this.transformation = transformation;
    }

    public String alg() {
        return this.alg;
    }

    public String transformation() {
        return this.transformation;
    }

    public static AuthType fromSignType(String signType) {
        return Arrays.stream(AuthType.values()).filter(requestAuthType -> Objects.equals(requestAuthType.signType, signType)).findAny().orElseThrow(() -> new PayException("This signType is not supported"));
    }

    public String toAuthHeader(String token) {
        return this.signType.concat(" ").concat(token);
    }
}

