/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.crypto;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.v3.crypto.AuthType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class AppMerchant {
    private final String appid;
    private final String apiV3Secret;
    private final JWK merchantJwk;

    @JsonCreator
    public AppMerchant(@JsonProperty(value="appid") String appid, @JsonProperty(value="apiV3Secret") String apiV3Secret, @JsonProperty(value="merchantJwk") JWK merchantJwk) {
        this.appid = appid;
        this.apiV3Secret = apiV3Secret;
        this.merchantJwk = merchantJwk;
    }

    public String merchantId() {
        return this.merchantJwk.getKeyID();
    }

    public AuthType authType() {
        return Objects.equals(KeyType.RSA, this.merchantJwk.getKeyType()) ? AuthType.SHA256_RSA2048 : AuthType.SM2_WITH_SM3;
    }

    public PrivateKey privateKey() {
        try {
            if (Objects.equals(KeyType.RSA, this.merchantJwk.getKeyType())) {
                return this.merchantJwk.toRSAKey().toPrivateKey();
            }
            return this.merchantJwk.toECKey().toPrivateKey();
        }
        catch (JOSEException e) {
            throw new PayException("Fail to load key", e);
        }
    }

    public PublicKey publicKey() {
        try {
            if (Objects.equals(KeyType.RSA, this.merchantJwk.getKeyType())) {
                return this.merchantJwk.toRSAKey().toPublicKey();
            }
            return this.merchantJwk.toECKey().toPublicKey();
        }
        catch (JOSEException e) {
            throw new PayException("Fail to load key", e);
        }
    }

    public String serialNumber() {
        return ((X509Certificate)this.merchantJwk.toPublicJWK().getParsedX509CertChain().get(0)).getSerialNumber().toString(16).toUpperCase();
    }

    public String toString() {
        return "AppMerchant{appid=" + this.appid + ", apiV3Secret=[PROTECTED]" + '}';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppMerchant)) {
            return false;
        }
        AppMerchant other = (AppMerchant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appid = this.getAppid();
        String other$appid = other.getAppid();
        if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
            return false;
        }
        String this$apiV3Secret = this.getApiV3Secret();
        String other$apiV3Secret = other.getApiV3Secret();
        if (this$apiV3Secret == null ? other$apiV3Secret != null : !this$apiV3Secret.equals(other$apiV3Secret)) {
            return false;
        }
        JWK this$merchantJwk = this.getMerchantJwk();
        JWK other$merchantJwk = other.getMerchantJwk();
        return !(this$merchantJwk == null ? other$merchantJwk != null : !this$merchantJwk.equals(other$merchantJwk));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppMerchant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
        String $apiV3Secret = this.getApiV3Secret();
        result = result * 59 + ($apiV3Secret == null ? 43 : $apiV3Secret.hashCode());
        JWK $merchantJwk = this.getMerchantJwk();
        result = result * 59 + ($merchantJwk == null ? 43 : $merchantJwk.hashCode());
        return result;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getApiV3Secret() {
        return this.apiV3Secret;
    }

    public JWK getMerchantJwk() {
        return this.merchantJwk;
    }
}

