/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.mp.api;

import cn.felord.mp.MpApp;
import cn.felord.mp.WeMpTokenCacheable;
import cn.felord.mp.api.CardApi;
import cn.felord.mp.api.MediaApi;
import cn.felord.mp.api.MessageApi;
import cn.felord.mp.api.WeChatMpApiClient;
import cn.felord.mp.retrofit.AccessTokenApi;
import okhttp3.ConnectionPool;
import okhttp3.logging.HttpLoggingInterceptor;

public class WechatMpApi {
    private final WeMpTokenCacheable weMpTokenCacheable;
    private final HttpLoggingInterceptor.Level level;
    private final ConnectionPool connectionPool;

    public WechatMpApi(WeMpTokenCacheable weMpTokenCacheable) {
        this(weMpTokenCacheable, new ConnectionPool());
    }

    public WechatMpApi(WeMpTokenCacheable weMpTokenCacheable, ConnectionPool connectionPool) {
        this(weMpTokenCacheable, connectionPool, HttpLoggingInterceptor.Level.NONE);
    }

    public WechatMpApi(WeMpTokenCacheable weMpTokenCacheable, HttpLoggingInterceptor.Level level) {
        this(weMpTokenCacheable, new ConnectionPool(), level);
    }

    public WechatMpApi(WeMpTokenCacheable weMpTokenCacheable, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        this.weMpTokenCacheable = weMpTokenCacheable;
        this.connectionPool = connectionPool;
        this.level = level;
    }

    public MediaApi mediaApi(MpApp mpApp) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weMpTokenCacheable, mpApp);
        return new MediaApi(WeChatMpApiClient.init(tokenApi, this.connectionPool, this.level).retrofit());
    }

    public CardApi cardApi(MpApp mpApp) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weMpTokenCacheable, mpApp);
        return (CardApi)WeChatMpApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(CardApi.class);
    }

    public MessageApi messageApi(MpApp mpApp) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weMpTokenCacheable, mpApp);
        return (MessageApi)WeChatMpApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(MessageApi.class);
    }
}

