/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.mp.retrofit;

import cn.felord.mp.retrofit.TokenApi;
import cn.felord.retrofit.json.JacksonObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class TokenInterceptor
implements Interceptor {
    public static final ObjectMapper MAPPER = JacksonObjectMapperFactory.create();
    private static final MediaType JSON_UTF_8 = MediaType.parse((String)"application/json; charset=UTF-8");
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private final TokenApi tokenApi;

    public TokenInterceptor(TokenApi tokenApi) {
        this.tokenApi = tokenApi;
    }

    @NotNull
    public final Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        return this.doRequest(chain);
    }

    private Response doRequest(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpUrl oldHttpUrl = request.url();
        String tokenResponse = this.tokenApi.getToken();
        Request requestWithAccessToken = request.newBuilder().url(oldHttpUrl.newBuilder().addQueryParameter("access_token", tokenResponse).build()).build();
        return chain.proceed(requestWithAccessToken);
    }
}

