/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.mp.retrofit;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

final class ResponseBodyCallAdapterFactory
extends CallAdapter.Factory {
    public static final ResponseBodyCallAdapterFactory INSTANCE = new ResponseBodyCallAdapterFactory();

    private ResponseBodyCallAdapterFactory() {
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        Class rawType = ResponseBodyCallAdapterFactory.getRawType((Type)returnType);
        if (Void.TYPE.isAssignableFrom(rawType)) {
            return null;
        }
        if (Response.class.isAssignableFrom(rawType)) {
            return null;
        }
        if (Call.class.isAssignableFrom(rawType)) {
            return null;
        }
        if (CompletableFuture.class.isAssignableFrom(rawType)) {
            return null;
        }
        return new ResponseBodyCallAdapter(returnType);
    }

    static final class ResponseBodyCallAdapter<R>
    implements CallAdapter<R, R> {
        private final Type returnType;

        ResponseBodyCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            return this.returnType;
        }

        public R adapt(Call<R> call) {
            Response response;
            try {
                response = call.execute();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return (R)response.body();
        }
    }
}

