/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.utils;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;

public class AlternativeJdkIdGenerator {
    private final Random random;

    public AlternativeJdkIdGenerator() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] seed = new byte[8];
        secureRandom.nextBytes(seed);
        this.random = new Random(new BigInteger(seed).longValue());
    }

    public String generate32() {
        byte[] randomBytes = new byte[16];
        this.random.nextBytes(randomBytes);
        long mostSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        long leastSigBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return this.doGenerate32(mostSigBits, leastSigBits);
    }

    private String doGenerate32(long mostSigBits, long leastSigBits) {
        return AlternativeJdkIdGenerator.digits(mostSigBits >> 32, 8) + AlternativeJdkIdGenerator.digits(mostSigBits >> 16, 4) + AlternativeJdkIdGenerator.digits(mostSigBits, 4) + AlternativeJdkIdGenerator.digits(leastSigBits >> 48, 4) + AlternativeJdkIdGenerator.digits(leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }
}

