/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public class UnixInstantConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return Instant.class == type;
    }

    public String toString(Object obj) {
        Instant instant = (Instant)obj;
        return String.valueOf(instant.toEpochMilli());
    }

    public Instant fromString(String str) {
        try {
            return Instant.ofEpochSecond(Long.parseLong(str));
        }
        catch (DateTimeParseException ex) {
            ConversionException exception = new ConversionException("Cannot parse value as instant", (Throwable)ex);
            exception.add("value", str);
            throw exception;
        }
    }
}

