/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.utils;

import cn.felord.domain.FileMediaType;
import cn.felord.domain.MultipartResource;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public final class MediaUtil {
    private MediaUtil() {
    }

    public static MultipartBody toMultipartBody(MultipartResource resource) {
        String fileName = resource.getFileName();
        MediaType mediaType = Objects.nonNull(resource.getMediaType()) ? resource.getMediaType() : FileMediaType.fromFileName(fileName).mediaType();
        RequestBody requestBody = RequestBody.create((byte[])resource.getSource(), (MediaType)mediaType);
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("media", fileName, requestBody).build();
    }
}

