/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public final class FileTools {
    public static final int BUFFER_SIZE = 4096;

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileTools.copy(in, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        if (Objects.isNull(in)) {
            throw new IllegalArgumentException("InputStream is null");
        }
        if (Objects.isNull(out)) {
            throw new IllegalArgumentException("OutputStream is null");
        }
        try {
            int bytesRead;
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

