/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit.json;

import cn.felord.retrofit.json.UnixInstantSerializer;
import cn.felord.retrofit.json.YearMonthNumberDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.YearMonthSerializer;
import java.time.Instant;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;

public final class JacksonObjectMapperFactory {
    private static final DateTimeFormatter yearMonth = DateTimeFormatter.ofPattern("uMM");

    private JacksonObjectMapperFactory() {
    }

    public static ObjectMapper create() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(Instant.class, (JsonSerializer)UnixInstantSerializer.INSTANCE);
        javaTimeModule.addSerializer(YearMonth.class, (JsonSerializer)new YearMonthSerializer(yearMonth));
        javaTimeModule.addDeserializer(YearMonth.class, (JsonDeserializer)new YearMonthNumberDeserializer(yearMonth));
        return new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)javaTimeModule);
    }
}

