/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain;

import cn.felord.utils.StringUtils;
import java.util.Arrays;
import java.util.Objects;
import okhttp3.MediaType;

public enum FileMediaType {
    ALL("*", "application/octet-stream"),
    PDF("pdf", "application/pdf"),
    XML("xml", "application/xml"),
    GIF("gif", "image/gif"),
    JPEG("jpeg", "image/jpeg"),
    JPG("jpg", "image/jpeg"),
    PNG("png", "image/png"),
    MARKDOWN("md", "text/markdown"),
    MP4("mp4", "video/mp4"),
    AMR("amr", "audio/amr"),
    SPEEX("speex", "voice/speex"),
    ZIP("zip", "application/x-zip-compressed"),
    PPT("ppt", "application/vnd.ms-powerpoint"),
    PPTX("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation"),
    DOC("doc", "application/msword"),
    DOCX("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
    XLS("xls", "application/vnd.ms-excel"),
    XLSX("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

    private final String extension;
    private final String mediaType;

    private FileMediaType(String extension, String mediaType) {
        this.extension = extension;
        this.mediaType = mediaType;
    }

    public static FileMediaType fromFileName(String fileName) {
        String filenameExtension = StringUtils.getFilenameExtension(fileName);
        return Arrays.stream(FileMediaType.values()).filter(fileMediaType -> Objects.equals(fileMediaType.extension, filenameExtension)).findAny().orElse(ALL);
    }

    public static FileMediaType extension(MediaType mediaType) {
        return Arrays.stream(FileMediaType.values()).filter(fileMediaType -> Objects.equals(fileMediaType.mediaType, mediaType.type())).findAny().orElse(ALL);
    }

    public String extension() {
        return this.extension;
    }

    public MediaType mediaType() {
        return MediaType.parse((String)this.mediaType);
    }
}

