/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.callback;

import cn.felord.callback.CustomizableThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class CallbackAsyncConsumer<EVENT> {
    private final ExecutorService executor;
    private final Consumer<EVENT> eventBodyConsumer;

    public CallbackAsyncConsumer(Consumer<EVENT> eventBodyConsumer) {
        this(20, 100, 90L, 1500, eventBodyConsumer);
    }

    public CallbackAsyncConsumer(int corePoolSize, int maximumPoolSize, long keepAliveSecond, int capacity, Consumer<EVENT> eventBodyConsumer) {
        this(new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveSecond, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(capacity), new CustomizableThreadFactory("WECOM-CALLBACK-THREAD-POOL-")), eventBodyConsumer);
    }

    public CallbackAsyncConsumer(ExecutorService executor, Consumer<EVENT> eventBodyConsumer) {
        this.executor = executor;
        this.eventBodyConsumer = eventBodyConsumer;
    }

    public void asyncAction(EVENT eventBody) {
        Thread thread = new Thread(() -> this.eventBodyConsumer.accept(eventBody));
        this.executor.execute(thread);
    }
}

