/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.AgentDetails;
import cn.felord.WeComException;
import cn.felord.domain.GenericResponse;
import cn.felord.domain.WeComResponse;
import cn.felord.domain.agent.AgentDetailsResponse;
import cn.felord.domain.agent.AgentMenuBtn;
import cn.felord.domain.agent.AgentMenuBtns;
import cn.felord.domain.agent.AgentSettingRequest;
import cn.felord.domain.agent.Image;
import cn.felord.domain.agent.ImageWorkbenchTemplate;
import cn.felord.domain.agent.Items;
import cn.felord.domain.agent.KeyData;
import cn.felord.domain.agent.KeyDataWorkbenchTemplate;
import cn.felord.domain.agent.ListWorkbenchTemplate;
import cn.felord.domain.agent.UserImageWorkbenchTemplate;
import cn.felord.domain.agent.UserKeyDataWorkbenchTemplate;
import cn.felord.domain.agent.UserListWorkbenchTemplate;
import cn.felord.domain.agent.UserWebviewWorkbenchTemplate;
import cn.felord.domain.agent.UserWorkBenchSetting;
import cn.felord.domain.agent.UserWorkbenchTemplate;
import cn.felord.domain.agent.Webview;
import cn.felord.domain.agent.WebviewWorkbenchTemplate;
import cn.felord.domain.agent.WorkBenchSetting;
import cn.felord.domain.agent.WorkbenchDetailResponse;
import cn.felord.domain.agent.WorkbenchTemplate;
import cn.felord.enumeration.WorkbenchType;
import cn.felord.reactive.api.InternalAgentManagerApi;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import retrofit2.Retrofit;
import retrofit2.http.Body;

public class AgentManagerApi {
    private final InternalAgentManagerApi internalAgentManagerApi;
    private final AgentDetails agentDetails;

    AgentManagerApi(Retrofit retrofit, AgentDetails agentDetails) {
        this.internalAgentManagerApi = (InternalAgentManagerApi)retrofit.create(InternalAgentManagerApi.class);
        this.agentDetails = agentDetails;
    }

    public Single<AgentDetailsResponse> getAgentDetails() {
        return this.internalAgentManagerApi.getAgentDetails(this.agentDetails.getAgentId());
    }

    public Single<WeComResponse> settings(AgentSettingRequest request) {
        return this.internalAgentManagerApi.settings(Settings.from(this.agentDetails.getAgentId(), request));
    }

    public Single<WeComResponse> createMenu(AgentMenuBtns request) {
        return this.internalAgentManagerApi.createMenu(this.agentDetails.getAgentId(), request);
    }

    public Single<GenericResponse<List<AgentMenuBtn>>> getMenu() {
        return this.internalAgentManagerApi.getMenu(this.agentDetails.getAgentId());
    }

    public Single<WeComResponse> deleteMenu() {
        return this.internalAgentManagerApi.deleteMenu(this.agentDetails.getAgentId());
    }

    public Single<WeComResponse> setWorkbenchTemplate(WorkBenchSetting<?> setting) {
        String agentId = this.agentDetails.getAgentId();
        boolean replaceUserData = setting.isReplaceUserData();
        WorkbenchTemplate template = WorkbenchTemplate.normal((String)agentId, (boolean)replaceUserData);
        WorkbenchType type = setting.getType();
        if (Objects.equals(WorkbenchType.KEY_DATA, type)) {
            template = new KeyDataWorkbenchTemplate(agentId, replaceUserData, (KeyData)setting.getBody());
        } else if (Objects.equals(WorkbenchType.IMAGE, type)) {
            template = new ImageWorkbenchTemplate(agentId, replaceUserData, (Image)setting.getBody());
        } else if (Objects.equals(WorkbenchType.LIST, type)) {
            template = new ListWorkbenchTemplate(agentId, replaceUserData, (Items)setting.getBody());
        } else if (Objects.equals(WorkbenchType.WEBVIEW, type)) {
            template = new WebviewWorkbenchTemplate(agentId, replaceUserData, (Webview)setting.getBody());
        }
        return this.internalAgentManagerApi.setWorkbenchTemplate(template);
    }

    public Single<WorkbenchDetailResponse> getWorkbenchTemplate() {
        return this.internalAgentManagerApi.getWorkbenchTemplate(Collections.singletonMap("agentid", this.agentDetails.getAgentId()));
    }

    public Single<WeComResponse> setWorkbenchData(@Body UserWorkBenchSetting<?> userSetting) {
        UserKeyDataWorkbenchTemplate template;
        String agentId = this.agentDetails.getAgentId();
        String userid = userSetting.getUserid();
        WorkbenchType type = userSetting.getType();
        if (Objects.equals(WorkbenchType.KEY_DATA, type)) {
            template = new UserKeyDataWorkbenchTemplate(agentId, userid, (KeyData)userSetting.getBody());
        } else if (Objects.equals(WorkbenchType.IMAGE, type)) {
            template = new UserImageWorkbenchTemplate(agentId, userid, (Image)userSetting.getBody());
        } else if (Objects.equals(WorkbenchType.LIST, type)) {
            template = new UserListWorkbenchTemplate(agentId, userid, (Items)userSetting.getBody());
        } else if (Objects.equals(WorkbenchType.WEBVIEW, type)) {
            template = new UserWebviewWorkbenchTemplate(agentId, userid, (Webview)userSetting.getBody());
        } else {
            throw new WeComException("invalid workbench type");
        }
        return this.internalAgentManagerApi.setWorkbenchData((UserWorkbenchTemplate)template);
    }

    public static class Settings
    extends AgentSettingRequest {
        private final String agentid;

        static Settings from(String agentid, AgentSettingRequest request) {
            Settings settings = new Settings(agentid);
            settings.setDescription(request.getDescription());
            settings.setHomeUrl(request.getHomeUrl());
            settings.setIsreportenter(request.getIsreportenter());
            settings.setLogoMediaid(request.getLogoMediaid());
            settings.setName(request.getName());
            settings.setRedirectDomain(request.getRedirectDomain());
            settings.setReportLocationFlag(request.getReportLocationFlag());
            return settings;
        }

        private Settings(String agentid) {
            this.agentid = agentid;
        }

        public String getAgentid() {
            return this.agentid;
        }
    }
}

