/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.AgentDetails;
import cn.felord.WeComTokenCacheable;
import cn.felord.reactive.api.ExternalCorPayApi;
import cn.felord.reactive.api.ExternalPayAccountApi;
import cn.felord.reactive.api.InternalCorPayApi;
import cn.felord.reactive.api.MiniAppPayApi;
import cn.felord.reactive.api.WorkWeChatApiClient;
import cn.felord.retrofit.AccessTokenApi;
import cn.felord.retrofit.ssl.SSLManager;
import okhttp3.ConnectionPool;
import okhttp3.logging.HttpLoggingInterceptor;

public class PayApi {
    private final WeComTokenCacheable weComTokenCacheable;
    private final ConnectionPool connectionPool;
    private final HttpLoggingInterceptor.Level level;

    PayApi(WeComTokenCacheable weComTokenCacheable, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        this.weComTokenCacheable = weComTokenCacheable;
        this.connectionPool = connectionPool;
        this.level = level;
    }

    public InternalCorPayApi internal(String paySecret, String payAgentSecret, SSLManager sslManager) {
        return new InternalCorPayApi(paySecret, payAgentSecret, sslManager, this.connectionPool, this.level);
    }

    public ExternalCorPayApi external(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (ExternalCorPayApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(ExternalCorPayApi.class);
    }

    public ExternalPayAccountApi externalPayAccountApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (ExternalPayAccountApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(ExternalPayAccountApi.class);
    }

    public MiniAppPayApi miniAppPay(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (MiniAppPayApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(MiniAppPayApi.class);
    }
}

