/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.domain.GenericResponse;
import cn.felord.domain.MultipartResource;
import cn.felord.domain.common.JobId;
import cn.felord.domain.media.MediaJobResponse;
import cn.felord.domain.media.MediaResponse;
import cn.felord.domain.media.MediaUploadRequest;
import cn.felord.enumeration.MediaAttachmentType;
import cn.felord.enumeration.MediaTypeEnum;
import cn.felord.reactive.api.InternalMediaApi;
import cn.felord.utils.MediaUtil;
import io.reactivex.rxjava3.core.Single;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;

public class MediaApi {
    private final InternalMediaApi internalMediaApi;

    MediaApi(Retrofit retrofit) {
        this.internalMediaApi = (InternalMediaApi)retrofit.create(InternalMediaApi.class);
    }

    public Single<MediaResponse> uploadAttachment(MediaTypeEnum mediaType, MediaAttachmentType attachmentType, MultipartResource resource) {
        return this.internalMediaApi.uploadAttachment(mediaType.type(), attachmentType.getType(), MediaUtil.toMultipartBody((MultipartResource)resource));
    }

    public Single<MediaResponse> uploadMedia(MediaTypeEnum mediaType, MultipartResource resource) {
        return this.internalMediaApi.uploadMedia(mediaType.type(), MediaUtil.toMultipartBody((MultipartResource)resource));
    }

    public Single<MediaResponse> uploadImage(MultipartResource resource) {
        return this.internalMediaApi.uploadImage(MediaUtil.toMultipartBody((MultipartResource)resource));
    }

    public Single<Response> getMedia(String mediaId) {
        return this.internalMediaApi.getMedia(mediaId);
    }

    public Single<Response> getMediaJsSdk(String mediaId) {
        return this.internalMediaApi.getMediaJsSdk(mediaId);
    }

    public Single<GenericResponse<String>> uploadByUrl(MediaUploadRequest request) {
        return this.internalMediaApi.uploadByUrl(request);
    }

    public Single<MediaJobResponse> getUploadByUrlResult(@Body JobId jobId) {
        return this.internalMediaApi.getUploadByUrlResult(jobId);
    }

    public Single<GenericResponse<String>> uploadPayImage(MultipartResource resource) {
        return this.internalMediaApi.uploadPayImage(MediaUtil.toMultipartBody((MultipartResource)resource));
    }
}

