/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.domain.corpay.internal.RedPackRecordRequest;
import cn.felord.domain.corpay.internal.RedPackRecordResponse;
import cn.felord.domain.corpay.internal.RedPackRequest;
import cn.felord.domain.corpay.internal.RedPackResponse;
import cn.felord.domain.corpay.internal.TransPocketRecordRequest;
import cn.felord.domain.corpay.internal.TransPocketRecordResponse;
import cn.felord.domain.corpay.internal.TransPocketRequest;
import cn.felord.domain.corpay.internal.TransPocketResponse;
import cn.felord.enumeration.PaySignType;
import cn.felord.reactive.api.MmPayMktTransfersApi;
import cn.felord.retrofit.WorkWechatRetrofitFactory;
import cn.felord.retrofit.ssl.SSLManager;
import cn.felord.xml.XStreamXmlReader;
import io.reactivex.rxjava3.core.Single;
import okhttp3.ConnectionPool;
import okhttp3.logging.HttpLoggingInterceptor;

public class InternalCorPayApi {
    private final String paySecret;
    private final String payAgentSecret;
    private final MmPayMktTransfersApi mmPayMktTransfersApi;

    InternalCorPayApi(String paySecret, String payAgentSecret, SSLManager sslManager, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        this.paySecret = paySecret;
        this.payAgentSecret = payAgentSecret;
        this.mmPayMktTransfersApi = (MmPayMktTransfersApi)WorkWechatRetrofitFactory.create((SSLManager)sslManager, (ConnectionPool)connectionPool, (HttpLoggingInterceptor.Level)level).create(MmPayMktTransfersApi.class);
    }

    public Single<RedPackResponse> sendWorkWxRedPack(RedPackRequest request) {
        request.workWxSign(this.payAgentSecret);
        return this.mmPayMktTransfersApi.sendWorkWxRedPack(request.xmlBody(this.paySecret, PaySignType.MD5)).map(xml -> (RedPackResponse)XStreamXmlReader.INSTANCE.read(xml, RedPackResponse.class));
    }

    public Single<RedPackRecordResponse> queryWorkWxRedPack(RedPackRecordRequest request) {
        return this.mmPayMktTransfersApi.queryWorkWxRedPack(request.xmlBody(this.paySecret, PaySignType.MD5)).map(xml -> (RedPackRecordResponse)XStreamXmlReader.INSTANCE.read(xml, RedPackRecordResponse.class));
    }

    public Single<TransPocketResponse> payWwSpTrans2Pocket(TransPocketRequest request) {
        request.workWxSign(this.payAgentSecret);
        return this.mmPayMktTransfersApi.payWwSpTrans2Pocket(request.xmlBody(this.paySecret, PaySignType.MD5)).map(xml -> (TransPocketResponse)XStreamXmlReader.INSTANCE.read(xml, TransPocketResponse.class));
    }

    public Single<TransPocketRecordResponse> queryWwSpTrans2Pocket(TransPocketRecordRequest request) {
        return this.mmPayMktTransfersApi.queryWwSpTrans2Pocket(request.xmlBody(this.paySecret, PaySignType.MD5)).map(xml -> (TransPocketRecordResponse)XStreamXmlReader.INSTANCE.read(xml, TransPocketRecordResponse.class));
    }
}

