/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.AgentDetails;
import cn.felord.WeComAgentTicketCacheable;
import cn.felord.domain.authentication.JsTicketResponse;
import cn.felord.domain.jssdk.AgentConfigResponse;
import cn.felord.domain.jssdk.CorpConfigResponse;
import cn.felord.domain.jssdk.JSignatureResponse;
import cn.felord.reactive.api.JsApi;
import cn.felord.reactive.api.WorkWeChatApiClient;
import cn.felord.utils.Algorithms;
import cn.felord.utils.AlternativeJdkIdGenerator;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.text.MessageFormat;
import java.time.Instant;

public class SdkTicketApi {
    private static final String SIGNATURE_FORMATTER = "jsapi_ticket={0}&noncestr={1}&timestamp={2}&url={3}";
    private static final AlternativeJdkIdGenerator ID_GENERATOR = new AlternativeJdkIdGenerator();
    private final AgentDetails agentDetails;
    private final JsApi jsApi;
    private final WeComAgentTicketCacheable weComAgentTicketCacheable;

    SdkTicketApi(WorkWeChatApiClient workWeChatApiClient, WeComAgentTicketCacheable weComAgentTicketCacheable) {
        this.agentDetails = workWeChatApiClient.agentDetails();
        this.jsApi = (JsApi)workWeChatApiClient.retrofit().create(JsApi.class);
        this.weComAgentTicketCacheable = weComAgentTicketCacheable;
    }

    public Single<CorpConfigResponse> corpTicket(String url) {
        String corpId = this.agentDetails.getCorpId();
        String agentId = this.agentDetails.getAgentId();
        return Maybe.just((Object)this.weComAgentTicketCacheable.getCorpTicket(corpId, agentId)).switchIfEmpty((SingleSource)this.jsApi.corpJsApiTicket().map(JsTicketResponse::getTicket).map(corpTicket -> this.weComAgentTicketCacheable.putCorpTicket(corpId, agentId, corpTicket))).map(corpTicket -> {
            JSignatureResponse jSignatureResponse = this.sha1((String)corpTicket, url);
            CorpConfigResponse corpConfigResponse = new CorpConfigResponse();
            corpConfigResponse.setAppId(this.agentDetails.getCorpId());
            corpConfigResponse.setNonceStr(jSignatureResponse.getNonceStr());
            corpConfigResponse.setTimestamp(jSignatureResponse.getTimestamp());
            corpConfigResponse.setSignature(jSignatureResponse.getSignature());
            return corpConfigResponse;
        });
    }

    public Single<AgentConfigResponse> agentTicket(String url) {
        String corpId = this.agentDetails.getCorpId();
        String agentId = this.agentDetails.getAgentId();
        return Maybe.just((Object)this.weComAgentTicketCacheable.getAgentTicket(corpId, agentId)).switchIfEmpty((SingleSource)this.jsApi.agentJsApiTicket("agent_config").map(JsTicketResponse::getTicket).map(agentTicket -> this.weComAgentTicketCacheable.putAgentTicket(corpId, agentId, agentTicket))).map(agentTicket -> {
            JSignatureResponse jSignatureResponse = this.sha1((String)agentTicket, url);
            AgentConfigResponse agentConfigResponse = new AgentConfigResponse();
            agentConfigResponse.setCorpid(corpId);
            agentConfigResponse.setAgentid(agentId);
            agentConfigResponse.setNonceStr(jSignatureResponse.getNonceStr());
            agentConfigResponse.setTimestamp(jSignatureResponse.getTimestamp());
            agentConfigResponse.setSignature(jSignatureResponse.getSignature());
            return agentConfigResponse;
        });
    }

    private JSignatureResponse sha1(String ticket, String url) {
        String nonceStr = ID_GENERATOR.generate32();
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        String format = MessageFormat.format(SIGNATURE_FORMATTER, ticket, nonceStr, timestamp, url);
        JSignatureResponse jSignature = new JSignatureResponse();
        jSignature.setNonceStr(nonceStr);
        jSignature.setTimestamp(timestamp);
        jSignature.setSignature(Algorithms.sha1Hex((String)format));
        return jSignature;
    }
}

