/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.domain.GenericResponse;
import cn.felord.domain.common.JobId;
import cn.felord.domain.media.MediaJobResponse;
import cn.felord.domain.media.MediaResponse;
import cn.felord.domain.media.MediaUploadRequest;
import cn.felord.domain.media.MultipartResource;
import cn.felord.enumeration.FileMediaType;
import cn.felord.enumeration.MediaAttachmentType;
import cn.felord.enumeration.MediaTypeEnum;
import cn.felord.reactive.api.InternalMediaApi;
import io.reactivex.rxjava3.core.Single;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;

public class MediaApi {
    private final InternalMediaApi internalMediaApi;

    MediaApi(Retrofit retrofit) {
        this.internalMediaApi = (InternalMediaApi)retrofit.create(InternalMediaApi.class);
    }

    public Single<MediaResponse> uploadAttachment(MediaTypeEnum mediaType, MediaAttachmentType attachmentType, MultipartResource resource) {
        return this.internalMediaApi.uploadAttachment(mediaType.type(), attachmentType.getType(), this.toMultipartBody(resource));
    }

    public Single<MediaResponse> uploadMedia(MediaTypeEnum mediaType, MultipartResource resource) {
        return this.internalMediaApi.uploadMedia(mediaType.type(), this.toMultipartBody(resource));
    }

    public Single<MediaResponse> uploadImage(MultipartResource resource) {
        return this.internalMediaApi.uploadImage(this.toMultipartBody(resource));
    }

    public Single<Response> getMedia(String mediaId) {
        return this.internalMediaApi.getMedia(mediaId);
    }

    public Single<Response> getMediaJsSdk(String mediaId) {
        return this.internalMediaApi.getMediaJsSdk(mediaId);
    }

    public Single<GenericResponse<String>> uploadByUrl(MediaUploadRequest request) {
        return this.internalMediaApi.uploadByUrl(request);
    }

    public Single<MediaJobResponse> getUploadByUrlResult(@Body JobId jobId) {
        return this.internalMediaApi.getUploadByUrlResult(jobId);
    }

    private MultipartBody toMultipartBody(MultipartResource resource) {
        String fileName = resource.getFileName();
        MediaType mediaType = Objects.nonNull(resource.getMediaType()) ? resource.getMediaType() : FileMediaType.fromFileName((String)fileName).mediaType();
        RequestBody requestBody = RequestBody.create((byte[])resource.getSource(), (MediaType)mediaType);
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("media", fileName, requestBody).build();
    }
}

