/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.domain.WeComResponse;
import cn.felord.domain.media.MediaResponse;
import cn.felord.domain.webhook.WebhookBody;
import cn.felord.enumeration.FileMediaType;
import cn.felord.reactive.api.InternalWebhookApi;
import io.reactivex.rxjava3.core.Single;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Retrofit;

public class WebhookApi {
    private final InternalWebhookApi internalWebhookApi;

    WebhookApi(Retrofit retrofit) {
        this.internalWebhookApi = (InternalWebhookApi)retrofit.create(InternalWebhookApi.class);
    }

    public <B extends WebhookBody> Single<WeComResponse> send(String key, B body) {
        return this.internalWebhookApi.send(key, body);
    }

    public Single<MediaResponse> uploadMedia(String webhookKey, File file) {
        String mediaTypeStr = FileMediaType.fromFileName((String)file.getName()).mediaType();
        RequestBody requestBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)mediaTypeStr));
        MultipartBody media = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("media", file.getName(), requestBody).build();
        return this.internalWebhookApi.uploadMedia(webhookKey, "file", media);
    }
}

