/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.domain.GenericResponse;
import cn.felord.domain.media.MediaResponse;
import cn.felord.domain.media.MediaUploadRequest;
import cn.felord.enumeration.FileMediaType;
import cn.felord.enumeration.MediaAttachmentType;
import cn.felord.enumeration.MediaTypeEnum;
import cn.felord.reactive.api.InternalMediaApi;
import io.reactivex.rxjava3.core.Single;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.Response;
import retrofit2.Retrofit;

public class MediaApi {
    private final InternalMediaApi internalMediaApi;

    MediaApi(Retrofit retrofit) {
        this.internalMediaApi = (InternalMediaApi)retrofit.create(InternalMediaApi.class);
    }

    public Single<MediaResponse> uploadAttachment(MediaTypeEnum mediaType, MediaAttachmentType attachmentType, File file) {
        return this.internalMediaApi.uploadAttachment(mediaType.type(), attachmentType.getType(), this.toMultipartBody(file));
    }

    public Single<MediaResponse> uploadMedia(MediaTypeEnum mediaType, File file) {
        return this.internalMediaApi.uploadMedia(mediaType.type(), this.toMultipartBody(file));
    }

    public Single<MediaResponse> uploadImage(File file) {
        return this.internalMediaApi.uploadImage(this.toMultipartBody(file));
    }

    public Single<Response> getMedia(String mediaId) {
        return this.internalMediaApi.getMedia(mediaId);
    }

    public Single<Response> getMediaJsSdk(String mediaId) {
        return this.internalMediaApi.getMediaJsSdk(mediaId);
    }

    public Single<GenericResponse<String>> uploadByUrl(MediaUploadRequest request) {
        return this.internalMediaApi.uploadByUrl(request);
    }

    private MultipartBody toMultipartBody(File file) {
        String mediaTypeStr = FileMediaType.fromFileName((String)file.getName()).mediaType();
        RequestBody requestBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)mediaTypeStr));
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("media", file.getName(), requestBody).build();
    }
}

