/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.reactive.api;

import cn.felord.domain.wedrive.BufferSource;
import cn.felord.domain.wedrive.FileDownloadResponse;
import cn.felord.domain.wedrive.FileId;
import cn.felord.domain.wedrive.SelectedTicket;
import cn.felord.reactive.api.InternalFileManagerApi;
import cn.felord.retrofit.RetrofitFactory;
import io.reactivex.rxjava3.core.Single;
import okhttp3.ResponseBody;
import retrofit2.Retrofit;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Url;

public class FileManagerApi {
    private final InternalFileManagerApi internalFileManagerApi;
    private final DownloadApi downloadApi;

    FileManagerApi(Retrofit retrofit) {
        this.internalFileManagerApi = (InternalFileManagerApi)retrofit.create(InternalFileManagerApi.class);
        this.downloadApi = (DownloadApi)RetrofitFactory.RETROFIT_.create(DownloadApi.class);
    }

    public Single<BufferSource> downloadByFileId(String fileid) {
        return this.internalFileManagerApi.getFileUrlByFileId(new FileId(fileid)).flatMap(this::download);
    }

    public Single<BufferSource> downloadBySelectedTicket(String selectedTicket) {
        return this.internalFileManagerApi.getFileUrlBySelectedTicket(new SelectedTicket(selectedTicket)).flatMap(this::download);
    }

    private Single<BufferSource> download(FileDownloadResponse downloadResponse) {
        String downloadUrl = downloadResponse.getDownloadUrl();
        String cookie = downloadResponse.getCookieName().concat("=").concat(downloadResponse.getCookieValue());
        return this.downloadApi.download(downloadUrl, cookie).map(body -> new BufferSource(body.contentType(), body.contentLength(), body.source()));
    }

    static interface DownloadApi {
        @POST
        public Single<ResponseBody> download(@Url String var1, @Header(value="Cookie") String var2);
    }
}

