/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.WechatMetaBean;
import cn.felord.payment.wechat.v3.WechatMetaContainer;
import cn.felord.payment.wechat.v3.model.ResponseSignVerifyParams;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Base64Utils;
import org.springframework.util.IdGenerator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SignatureProvider {
    private final IdGenerator nonceStrGenerator = new AlternativeJdkIdGenerator();
    private static final String SCHEMA = "WECHATPAY2-SHA256-RSA2048 ";
    public static final String TOKEN_PATTERN = "mchid=\"%s\",nonce_str=\"%s\",timestamp=\"%d\",serial_no=\"%s\",signature=\"%s\"";
    private static final Map<String, Certificate> CERTIFICATE_MAP = new ConcurrentHashMap<String, Certificate>();
    private static final String BC_PROVIDER = "BC";
    private final RestOperations restOperations = new RestTemplate();
    private final WechatMetaContainer wechatMetaContainer;

    public SignatureProvider(WechatMetaContainer wechatMetaContainer) {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bouncyCastleProvider);
        this.wechatMetaContainer = wechatMetaContainer;
        wechatMetaContainer.getTenantIds().forEach(this::refreshCertificate);
    }

    public String requestSign(String tenantId, String method, String canonicalUrl, String body) {
        long timestamp = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        String nonceStr = this.nonceStrGenerator.generateId().toString().replaceAll("-", "");
        WechatMetaBean wechatMetaBean = this.wechatMetaContainer.getWechatMeta(tenantId);
        PrivateKey privateKey = wechatMetaBean.getKeyPair().getPrivate();
        String encode = this.doRequestSign(privateKey, method, canonicalUrl, String.valueOf(timestamp), nonceStr, body);
        String serialNo = wechatMetaBean.getSerialNumber();
        String token = String.format(TOKEN_PATTERN, wechatMetaBean.getV3().getMchId(), nonceStr, timestamp, serialNo, encode);
        return SCHEMA.concat(token);
    }

    public String doRequestSign(PrivateKey privateKey, String ... orderedComponents) {
        Signature signer = Signature.getInstance("SHA256withRSA", BC_PROVIDER);
        signer.initSign(privateKey);
        String signatureStr = SignatureProvider.createSign(orderedComponents);
        signer.update(signatureStr.getBytes(StandardCharsets.UTF_8));
        return Base64Utils.encodeToString((byte[])signer.sign());
    }

    public boolean responseSignVerify(ResponseSignVerifyParams params) {
        String wechatpaySerial = params.getWechatpaySerial();
        if (CERTIFICATE_MAP.isEmpty() || !CERTIFICATE_MAP.containsKey(wechatpaySerial)) {
            this.wechatMetaContainer.getTenantIds().forEach(this::refreshCertificate);
        }
        Certificate certificate = CERTIFICATE_MAP.get(wechatpaySerial);
        String signatureStr = SignatureProvider.createSign(params.getWechatpayTimestamp(), params.getWechatpayNonce(), params.getBody());
        Signature signer = Signature.getInstance("SHA256withRSA");
        signer.initVerify(certificate);
        signer.update(signatureStr.getBytes(StandardCharsets.UTF_8));
        return signer.verify(Base64Utils.decodeFromString((String)params.getWechatpaySignature()));
    }

    private synchronized void refreshCertificate(String tenantId) {
        String url = WechatPayV3Type.CERT.uri(WeChatServer.CHINA);
        UriComponents uri = UriComponentsBuilder.fromHttpUrl((String)url).build();
        String canonicalUrl = uri.getPath();
        String encodedQuery = uri.getQuery();
        if (encodedQuery != null) {
            canonicalUrl = canonicalUrl + "?" + encodedQuery;
        }
        HttpMethod httpMethod = WechatPayV3Type.CERT.method();
        String authorization = this.requestSign(tenantId, httpMethod.name(), canonicalUrl, "");
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Authorization", authorization);
        headers.add("User-Agent", "X-Pay-Service");
        RequestEntity requestEntity = new RequestEntity((MultiValueMap)headers, httpMethod, uri.toUri());
        ResponseEntity responseEntity = this.restOperations.exchange(requestEntity, ObjectNode.class);
        ObjectNode bodyObjectNode = (ObjectNode)responseEntity.getBody();
        if (Objects.isNull(bodyObjectNode)) {
            throw new PayException("cant obtain the response body");
        }
        ArrayNode certificates = bodyObjectNode.withArray("data");
        if (certificates.isArray() && certificates.size() > 0) {
            CERTIFICATE_MAP.clear();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            certificates.forEach(objectNode -> {
                JsonNode encryptCertificate = objectNode.get("encrypt_certificate");
                String associatedData = encryptCertificate.get("associated_data").asText();
                String nonce = encryptCertificate.get("nonce").asText();
                String ciphertext = encryptCertificate.get("ciphertext").asText();
                String publicKey = this.decryptResponseBody(tenantId, associatedData, nonce, ciphertext);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(publicKey.getBytes(StandardCharsets.UTF_8));
                try {
                    Certificate certificate = certificateFactory.generateCertificate(inputStream);
                    String responseSerialNo = objectNode.get("serial_no").asText();
                    CERTIFICATE_MAP.put(responseSerialNo, certificate);
                }
                catch (CertificateException e) {
                    throw new PayException("An error occurred while generating the wechat v3 certificate, reason : " + e.getMessage());
                }
            });
        }
    }

    public String decryptResponseBody(String tenantId, String associatedData, String nonce, String ciphertext) {
        try {
            byte[] bytes;
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", BC_PROVIDER);
            String apiV3Key = this.wechatMetaContainer.getWechatMeta(tenantId).getV3().getAppV3Secret();
            SecretKeySpec key = new SecretKeySpec(apiV3Key.getBytes(StandardCharsets.UTF_8), "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce.getBytes(StandardCharsets.UTF_8));
            cipher.init(2, (Key)key, spec);
            cipher.updateAAD(associatedData.getBytes(StandardCharsets.UTF_8));
            try {
                bytes = cipher.doFinal(Base64Utils.decodeFromString((String)ciphertext));
            }
            catch (GeneralSecurityException e) {
                throw new PayException(e);
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new PayException(e);
        }
    }

    public WechatMetaContainer wechatMetaContainer() {
        return this.wechatMetaContainer;
    }

    public IdGenerator nonceStrGenerator() {
        return this.nonceStrGenerator;
    }

    private static String createSign(String ... components) {
        return Arrays.stream(components).collect(Collectors.joining("\n", "", "\n"));
    }
}

