/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat;

import cn.felord.payment.wechat.WechatPayProperties;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class WechatPayConfiguredCondition
extends SpringBootCondition {
    private static final Bindable<Map<String, WechatPayProperties.V3>> STRING_WECHAT_V3_MAP = Bindable.mapOf(String.class, WechatPayProperties.V3.class);

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Wechat Pay V3 Configured Condition", (Object[])new Object[0]);
        Map<String, WechatPayProperties.V3> v3 = this.getV3(context.getEnvironment());
        if (!v3.isEmpty()) {
            return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)("registered wechat mchIds " + v3.values().stream().map(WechatPayProperties.V3::getMchId).collect(Collectors.joining(", ")))));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("registered wechat pay configs"));
    }

    private Map<String, WechatPayProperties.V3> getV3(Environment environment) {
        return (Map)Binder.get((Environment)environment).bind("wechat.pay.v3", STRING_WECHAT_V3_MAP).orElse(Collections.emptyMap());
    }
}

