/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat;

import cn.felord.payment.wechat.WechatPayConfiguredCondition;
import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.v3.KeyPairFactory;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatApiProvider;
import cn.felord.payment.wechat.v3.WechatMetaBean;
import cn.felord.payment.wechat.v3.WechatMetaContainer;
import cn.felord.payment.wechat.v3.WechatPayClient;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={WechatPayConfiguredCondition.class})
@EnableConfigurationProperties(value={WechatPayProperties.class})
public class WechatPayConfiguration {
    private static final String CERT_ALIAS = "Tenpay Certificate";

    @Bean
    @ConditionalOnMissingBean
    WechatMetaContainer wechatMetaContainer(WechatPayProperties wechatPayProperties) {
        Map<String, WechatPayProperties.V3> v3Map = wechatPayProperties.getV3();
        WechatMetaContainer container = new WechatMetaContainer();
        KeyPairFactory keyPairFactory = new KeyPairFactory();
        v3Map.keySet().forEach(tenantId -> {
            WechatPayProperties.V3 v3 = (WechatPayProperties.V3)v3Map.get(tenantId);
            String certPath = v3.getCertPath();
            String mchId = v3.getMchId();
            WechatMetaBean wechatMetaBean = keyPairFactory.createPKCS12(certPath, CERT_ALIAS, mchId);
            wechatMetaBean.setV3(v3);
            wechatMetaBean.setTenantId((String)tenantId);
            container.addWechatMeta((String)tenantId, wechatMetaBean);
        });
        return container;
    }

    @Bean
    SignatureProvider signatureProvider(WechatMetaContainer wechatMetaContainer) {
        return new SignatureProvider(wechatMetaContainer);
    }

    @Bean
    public WechatPayClient wechatPayClient(SignatureProvider signatureProvider) {
        return new WechatPayClient(signatureProvider);
    }

    @Bean
    public WechatApiProvider wechatApiProvider(WechatPayClient wechatPayClient) {
        return new WechatApiProvider(wechatPayClient);
    }
}

