/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatMetaBean;
import cn.felord.payment.wechat.v3.WechatMetaContainer;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.TransactionQueryParams;
import cn.felord.payment.wechat.v3.model.partner.CloseTransParams;
import cn.felord.payment.wechat.v3.model.partner.PartnerPayParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.PrivateKey;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatPartnerPayApi
extends AbstractApi {
    public WechatPartnerPayApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> appPay(PartnerPayParams partnerPayParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.APP_PARTNER, partnerPayParams).function(this::payFunction).consumer(responseEntity -> {
            ObjectNode body = (ObjectNode)responseEntity.getBody();
            if (Objects.isNull(body)) {
                throw new PayException("response body cannot be resolved");
            }
            SignatureProvider signatureProvider = this.client().signatureProvider();
            WechatMetaContainer wechatMetaContainer = signatureProvider.wechatMetaContainer();
            WechatMetaBean wechatMetaBean = wechatMetaContainer.getWechatMeta(this.tenantId());
            PrivateKey privateKey = wechatMetaBean.getKeyPair().getPrivate();
            String subAppid = partnerPayParams.getSubAppid();
            long epochSecond = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
            String timestamp = String.valueOf(epochSecond);
            String nonceStr = signatureProvider.nonceStrGenerator().generateId().toString().replaceAll("-", "");
            String prepayId = body.get("prepay_id").asText();
            String paySign = signatureProvider.doRequestSign(true, privateKey, subAppid, timestamp, nonceStr, prepayId);
            body.put("appid", subAppid);
            body.put("partnerid", partnerPayParams.getSubMchid());
            body.put("prepayid", prepayId);
            body.put("package", "Sign=WXPay");
            body.put("nonceStr", nonceStr);
            body.put("timeStamp", timestamp);
            body.put("signType", "RSA");
            body.put("paySign", paySign);
            wechatResponseEntity.setHttpStatus(responseEntity.getStatusCodeValue());
            wechatResponseEntity.setBody(body);
        }).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> jsPay(PartnerPayParams partnerPayParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.JSAPI_PARTNER, partnerPayParams).function(this::payFunction).consumer(responseEntity -> {
            ObjectNode body = (ObjectNode)responseEntity.getBody();
            if (Objects.isNull(body)) {
                throw new PayException("response body cannot be resolved");
            }
            SignatureProvider signatureProvider = this.client().signatureProvider();
            WechatMetaContainer wechatMetaContainer = signatureProvider.wechatMetaContainer();
            WechatMetaBean wechatMetaBean = wechatMetaContainer.getWechatMeta(this.tenantId());
            PrivateKey privateKey = wechatMetaBean.getKeyPair().getPrivate();
            String subAppid = partnerPayParams.getSubAppid();
            long epochSecond = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
            String timestamp = String.valueOf(epochSecond);
            String nonceStr = signatureProvider.nonceStrGenerator().generateId().toString().replaceAll("-", "");
            String packageStr = "prepay_id=" + body.get("prepay_id").asText();
            String paySign = signatureProvider.doRequestSign(true, privateKey, subAppid, timestamp, nonceStr, packageStr);
            body.put("appId", subAppid);
            body.put("timeStamp", timestamp);
            body.put("nonceStr", nonceStr);
            body.put("package", packageStr);
            body.put("signType", "RSA");
            body.put("paySign", paySign);
            wechatResponseEntity.setHttpStatus(responseEntity.getStatusCodeValue());
            wechatResponseEntity.setBody(body);
        }).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> nativePay(PartnerPayParams partnerPayParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.NATIVE_PARTNER, partnerPayParams).function(this::payFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> h5Pay(PartnerPayParams partnerPayParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MWEB_PARTNER, partnerPayParams).function(this::payFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> payFunction(WechatPayV3Type type, PartnerPayParams partnerPayParams) {
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        partnerPayParams.setSpAppid(v3.getAppId());
        partnerPayParams.setSpMchid(v3.getMchId());
        String notifyUrl = v3.getDomain().concat(partnerPayParams.getNotifyUrl());
        partnerPayParams.setNotifyUrl(notifyUrl);
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        return this.Post(uri, partnerPayParams);
    }

    public WechatResponseEntity<ObjectNode> queryTransactionById(TransactionQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.TRANSACTION_TRANSACTION_ID_PARTNER, params).function(this::queryTransactionFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryTransactionByOutTradeNo(TransactionQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.TRANSACTION_OUT_TRADE_NO_PARTNER, params).function(this::queryTransactionFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> queryTransactionFunction(WechatPayV3Type type, TransactionQueryParams params) {
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.add((Object)"sp_mchid", (Object)v3.getMchId());
        queryParams.add((Object)"sub_mchid", (Object)params.getMchId());
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{params.getTransactionIdOrOutTradeNo()}).toUri();
        return this.Get(uri);
    }

    public WechatResponseEntity<ObjectNode> close(CloseTransParams closeTransParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.CLOSE_PARTNER, closeTransParams).function(this::closeByOutTradeNoFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> closeByOutTradeNoFunction(WechatPayV3Type type, CloseTransParams closeTransParams) {
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        HashMap<String, String> queryParams = new HashMap<String, String>(1);
        queryParams.put("sp_mchid", v3.getMchId());
        queryParams.put("sub_mchid", closeTransParams.getSubMchid());
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{closeTransParams.getOutTradeNo()}).toUri();
        return this.Post(uri, queryParams);
    }
}

