/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.CouponStatus;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.busifavor.BusiCouponCodeUploadParams;
import cn.felord.payment.wechat.v3.model.busifavor.BusiFavorAssociateInfo;
import cn.felord.payment.wechat.v3.model.busifavor.BusiFavorBudgetParams;
import cn.felord.payment.wechat.v3.model.busifavor.BusiFavorCallbackSettingParams;
import cn.felord.payment.wechat.v3.model.busifavor.BusiFavorCreateParams;
import cn.felord.payment.wechat.v3.model.busifavor.BusiFavorDeactivateParams;
import cn.felord.payment.wechat.v3.model.busifavor.BusiFavorRefundParams;
import cn.felord.payment.wechat.v3.model.busifavor.BusiFavorUpdateParams;
import cn.felord.payment.wechat.v3.model.busifavor.BusiFavorUseParams;
import cn.felord.payment.wechat.v3.model.busifavor.UserBusiCouponQueryParams;
import cn.felord.payment.wechat.v3.model.busifavor.UserBusiFavorQueryParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.Optional;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatMarketingBusiFavorApi
extends AbstractApi {
    public WechatMarketingBusiFavorApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> createStock(BusiFavorCreateParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_CREATE_STOCKS, params).function(this::createStocksFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> createStocksFunction(WechatPayV3Type type, BusiFavorCreateParams busiFavorCreateParams) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        if (!StringUtils.hasText((String)busiFavorCreateParams.getBelongMerchant())) {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            String mchId = v3.getMchId();
            busiFavorCreateParams.setBelongMerchant(mchId);
        }
        return this.Post(uri, busiFavorCreateParams);
    }

    public WechatResponseEntity<ObjectNode> queryStockDetail(String stockId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_STOCKS_DETAIL, stockId).function((type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> use(BusiFavorUseParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_COUPON_USE, params).function((type, useParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            if (!StringUtils.hasText((String)params.getAppid())) {
                WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
                String appId = v3.getAppId();
                useParams.setAppid(appId);
            }
            return this.Post(uri, useParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryUserStocks(UserBusiFavorQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_USER_COUPONS, params).function((type, userBusiFavorQueryParams) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            String appid = userBusiFavorQueryParams.getAppid();
            if (StringUtils.hasText((String)appid)) {
                queryParams.add((Object)"appid", (Object)appid);
            }
            queryParams.add((Object)"stock_id", (Object)userBusiFavorQueryParams.getStockId());
            Optional.ofNullable(userBusiFavorQueryParams.getCouponState()).ifPresent(arg_0 -> WechatMarketingBusiFavorApi.lambda$null$2((MultiValueMap)queryParams, arg_0));
            queryParams.add((Object)"creator_merchant", (Object)userBusiFavorQueryParams.getCreatorMerchant());
            queryParams.add((Object)"belong_merchant", (Object)userBusiFavorQueryParams.getBelongMerchant());
            queryParams.add((Object)"sender_merchant", (Object)userBusiFavorQueryParams.getSenderMerchant());
            queryParams.add((Object)"offset", (Object)String.valueOf(params.getOffset()));
            queryParams.add((Object)"limit", (Object)String.valueOf(params.getLimit()));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{userBusiFavorQueryParams.getOpenid()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryUserCoupon(UserBusiCouponQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_USER_COUPON, params).function((type, queryParams) -> {
            if (!StringUtils.hasText((String)params.getAppid())) {
                WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
                String appId = v3.getAppId();
                queryParams.setAppid(appId);
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{queryParams.getOpenid(), queryParams.getCouponCode(), queryParams.getAppid()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> uploadCouponCodes(BusiCouponCodeUploadParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_UPLOAD_COUPON_CODES, params).function((type, queryParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{queryParams.getStockId()}).toUri();
            queryParams.setStockId(null);
            return this.Post(uri, queryParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> setCallbacks(BusiFavorCallbackSettingParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_SETTING_CALLBACKS, params).function((type, queryParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, queryParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> getCallbacks(String mchId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_GET_CALLBACKS, mchId).function((type, id) -> {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA));
            if (StringUtils.hasText((String)id)) {
                LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
                queryParams.add((Object)"mchid", id);
                uriComponentsBuilder.queryParams((MultiValueMap)queryParams);
            }
            URI uri = uriComponentsBuilder.build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> associate(BusiFavorAssociateInfo associateInfo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_ASSOCIATE, associateInfo).function(this::associateFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> disassociate(BusiFavorAssociateInfo associateInfo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_DISASSOCIATE, associateInfo).function(this::associateFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> associateFunction(WechatPayV3Type type, BusiFavorAssociateInfo associateInfo) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        return this.Post(uri, associateInfo);
    }

    public WechatResponseEntity<ObjectNode> budget(BusiFavorBudgetParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_BUDGET, params).function((type, budgetParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{budgetParams.getStockId()}).toUri();
            budgetParams.setStockId(null);
            return this.Post(uri, budgetParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> updateStock(BusiFavorUpdateParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_UPDATE, params).function((type, updateParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{updateParams.getStockId()}).toUri();
            updateParams.setStockId(null);
            return this.Patch(uri, updateParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> refund(BusiFavorRefundParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_RETURN, params).function((type, refundParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, refundParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> deactivate(BusiFavorDeactivateParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_BUSI_FAVOR_DEACTIVATE, params).function((type, deactivateParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, deactivateParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private static /* synthetic */ void lambda$null$2(MultiValueMap queryParams, CouponStatus state) {
        queryParams.add((Object)"coupon_state", (Object)state.name());
    }
}

