/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.batchtransfer.CreateBatchTransferParams;
import cn.felord.payment.wechat.v3.model.batchtransfer.QueryBatchTransferDetailParams;
import cn.felord.payment.wechat.v3.model.batchtransfer.QueryBatchTransferParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatBatchTransferApi
extends AbstractApi {
    public WechatBatchTransferApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> batchTransfer(CreateBatchTransferParams createBatchTransferParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_REQ, createBatchTransferParams).function(this::batchTransferFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> batchTransferFunction(WechatPayV3Type type, CreateBatchTransferParams createBatchTransferParams) {
        List<CreateBatchTransferParams.TransferDetailListItem> transferDetailList = createBatchTransferParams.getTransferDetailList();
        SignatureProvider signatureProvider = this.client().signatureProvider();
        X509WechatCertificateInfo certificate = signatureProvider.getCertificate();
        List<CreateBatchTransferParams.TransferDetailListItem> encrypted = transferDetailList.stream().peek(transferDetailListItem -> {
            String userName = transferDetailListItem.getUserName();
            X509Certificate x509Certificate = certificate.getX509Certificate();
            String encryptedUserName = signatureProvider.encryptRequestMessage(userName, x509Certificate);
            transferDetailListItem.setUserName(encryptedUserName);
            String userIdCard = transferDetailListItem.getUserIdCard();
            if (StringUtils.hasText((String)userIdCard)) {
                String encryptedUserIdCard = signatureProvider.encryptRequestMessage(userIdCard, x509Certificate);
                transferDetailListItem.setUserIdCard(encryptedUserIdCard);
            }
        }).collect(Collectors.toList());
        createBatchTransferParams.setTransferDetailList(encrypted);
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
        return this.Post(uri, createBatchTransferParams, httpHeaders);
    }

    public WechatResponseEntity<ObjectNode> queryBatchByBatchId(QueryBatchTransferParams queryBatchTransferParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_BATCH_ID, queryBatchTransferParams).function((type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"need_query_detail", (Object)params.getNeedQueryDetail().toString());
            queryParams.add((Object)"offset", (Object)params.getOffset().toString());
            queryParams.add((Object)"limit", (Object)params.getLimit().toString());
            queryParams.add((Object)"detail_status", (Object)params.getDetailStatus().name());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{params.getCode()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBatchDetailByWechat(QueryBatchTransferDetailParams queryBatchTransferDetailParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_DETAIL_WECHAT, queryBatchTransferDetailParams).function((type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"batch_id", (Object)params.getBatchIdOrOutBatchNo());
            queryParams.add((Object)"detail_id", (Object)params.getDetailIdOrOutDetailNo());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand((Map)queryParams).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBatchByOutBatchNo(QueryBatchTransferParams queryBatchTransferParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_OUT_BATCH_NO, queryBatchTransferParams).function((type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"need_query_detail", (Object)params.getNeedQueryDetail().toString());
            queryParams.add((Object)"offset", (Object)params.getOffset().toString());
            queryParams.add((Object)"limit", (Object)params.getLimit().toString());
            queryParams.add((Object)"detail_status", (Object)params.getDetailStatus().name());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{params.getCode()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBatchDetailByMch(QueryBatchTransferDetailParams queryBatchTransferDetailParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_DETAIL_MCH, queryBatchTransferDetailParams).function((type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"out_batch_no", (Object)params.getBatchIdOrOutBatchNo());
            queryParams.add((Object)"out_detail_no", (Object)params.getDetailIdOrOutDetailNo());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand((Map)queryParams).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> receiptBill(String outBatchNo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_BILL_RECEIPT, outBatchNo).function((type, batchNo) -> {
            HashMap<String, String> body = new HashMap<String, String>(1);
            body.put("out_batch_no", outBatchNo);
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, body);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public ResponseEntity<Resource> downloadBill(String outBatchNo) {
        WechatResponseEntity wechatResponseEntity = new WechatResponseEntity();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_DOWNLOAD_BILL, outBatchNo).function((type, batchNo) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{batchNo}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        String downloadUrl = ((ObjectNode)wechatResponseEntity.getBody()).get("download_url").asText();
        Assert.hasText((String)downloadUrl, (String)"download url has no text");
        return this.billResource(downloadUrl);
    }
}

