/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.enumeration.FundFlowAccountType;
import cn.felord.payment.wechat.enumeration.TarType;
import cn.felord.payment.wechat.enumeration.TradeBillType;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.WechatMetaBean;
import cn.felord.payment.wechat.v3.WechatMetaContainer;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.model.FundFlowBillParams;
import cn.felord.payment.wechat.v3.model.TradeBillParams;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.URI;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractApi {
    private final ObjectMapper mapper = new ObjectMapper();
    private final WechatPayClient wechatPayClient;
    private final String tenantId;

    public AbstractApi(WechatPayClient wechatPayClient, String tenantId) {
        this.applyObjectMapper(this.mapper);
        this.wechatPayClient = wechatPayClient;
        Assert.hasText((String)tenantId, (String)"tenantId is required");
        if (!this.container().getTenantIds().contains(tenantId)) {
            throw new PayException("tenantId is not in wechatMetaContainer");
        }
        this.tenantId = tenantId;
    }

    private void applyObjectMapper(ObjectMapper mapper) {
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule());
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public WechatPayClient client() {
        return this.wechatPayClient;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public WechatMetaContainer container() {
        return this.wechatPayClient.signatureProvider().wechatMetaContainer();
    }

    public WechatMetaBean wechatMetaBean() {
        return this.container().getWechatMeta(this.tenantId);
    }

    protected RequestEntity<?> Post(URI uri, Object params) {
        try {
            return ((RequestEntity.BodyBuilder)RequestEntity.post((URI)uri).header("Pay-TenantId", new String[]{this.tenantId})).body((Object)this.mapper.writeValueAsString(params));
        }
        catch (JsonProcessingException e) {
            throw new PayException("wechat app pay json failed");
        }
    }

    protected RequestEntity<?> Post(URI uri, Object params, HttpHeaders httpHeaders) {
        try {
            return ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)uri).header("Pay-TenantId", new String[]{this.tenantId})).headers(httpHeaders)).body((Object)this.mapper.writeValueAsString(params));
        }
        catch (JsonProcessingException e) {
            throw new PayException("wechat app pay json failed");
        }
    }

    protected RequestEntity<?> Get(URI uri) {
        return RequestEntity.get((URI)uri).header("Pay-TenantId", new String[]{this.tenantId}).build();
    }

    protected RequestEntity<?> Get(URI uri, HttpHeaders httpHeaders) {
        return RequestEntity.get((URI)uri).header("Pay-TenantId", new String[]{this.tenantId}).headers(httpHeaders).build();
    }

    protected RequestEntity<?> Patch(URI uri, Object params) {
        try {
            return ((RequestEntity.BodyBuilder)RequestEntity.patch((URI)uri).header("Pay-TenantId", new String[]{this.tenantId})).body((Object)this.mapper.writeValueAsString(params));
        }
        catch (JsonProcessingException e) {
            throw new PayException("wechat app pay json failed");
        }
    }

    protected String billDownload(String link) {
        return this.client().withType(WechatPayV3Type.FILE_DOWNLOAD, link).function((type, downloadUrl) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)downloadUrl).build().toUri();
            return this.Get(uri);
        }).download();
    }

    protected ResponseEntity<Resource> billResource(String link) {
        return this.client().withType(WechatPayV3Type.FILE_DOWNLOAD, link).function((type, downloadUrl) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)downloadUrl).build().toUri();
            return this.Get(uri);
        }).resource();
    }

    public final void downloadTradeBill(TradeBillParams tradeBillParams) {
        this.client().withType(WechatPayV3Type.TRADEBILL, tradeBillParams).function((wechatPayV3Type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            LocalDate billDate = params.getBillDate();
            queryParams.add((Object)"bill_date", (Object)billDate.format(DateTimeFormatter.ISO_DATE));
            String subMchid = params.getSubMchid();
            if (StringUtils.hasText((String)subMchid)) {
                queryParams.add((Object)"sub_mchid", (Object)subMchid);
            }
            TradeBillType tradeBillType = Optional.ofNullable(params.getBillType()).orElse(TradeBillType.ALL);
            queryParams.add((Object)"bill_type", (Object)tradeBillType.name());
            TarType tarType = params.getTarType();
            if (Objects.nonNull((Object)tarType)) {
                queryParams.add((Object)"tar_type", (Object)tarType.name());
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(response -> this.billDownload(((ObjectNode)Objects.requireNonNull(response.getBody())).get("download_url").asText())).request();
    }

    public final void downloadFundFlowBill(FundFlowBillParams fundFlowBillParams) {
        this.client().withType(WechatPayV3Type.FUNDFLOWBILL, fundFlowBillParams).function((wechatPayV3Type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            LocalDate billDate = params.getBillDate();
            queryParams.add((Object)"bill_date", (Object)billDate.format(DateTimeFormatter.ISO_DATE));
            FundFlowAccountType accountType = Optional.ofNullable(params.getAccountType()).orElse(FundFlowAccountType.BASIC);
            queryParams.add((Object)"account_type", (Object)accountType.name());
            TarType tarType = params.getTarType();
            if (Objects.nonNull((Object)tarType)) {
                queryParams.add((Object)"tar_type", (Object)tarType.name());
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(response -> this.billDownload(((ObjectNode)Objects.requireNonNull(response.getBody())).get("download_url").asText())).request();
    }
}

